/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.jpeg;

import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public final class JPEGMapProducer
extends DefaultRasterMapProducer {
    private static final Logger LOGGER = Logging.getLogger((String)(class$org$vfny$geoserver$wms$responses$map$jpeg$JPEGMapProducer == null ? (class$org$vfny$geoserver$wms$responses$map$jpeg$JPEGMapProducer = JPEGMapProducer.class$("org.vfny.geoserver.wms.responses.map.jpeg.JPEGMapProducer")) : class$org$vfny$geoserver$wms$responses$map$jpeg$JPEGMapProducer).toString());
    private Boolean JPEGNativeAcc;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$responses$map$jpeg$JPEGMapProducer;

    protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
        transparent = false;
        return super.prepareImage(width, height, palette, transparent);
    }

    public JPEGMapProducer(String outputFormat, WMS wms) {
        super(outputFormat, wms);
        this.JPEGNativeAcc = wms.getGeoServer().getJPEGNativeAcceleration();
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to write a JPEG image.");
        }
        new ImageWorker(image).writeJPEG((Object)outStream, "JPEG", 0.75f, this.JPEGNativeAcc.booleanValue());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing a JPEG done!!!");
        }
    }

    public String getContentDisposition() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

