/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.CoverageUtils;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.RasterMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.metatile.MetatileMapProducer;

public class GetMapResponse
implements Response {
    private static final Logger LOGGER = Logging.getLogger((String)(class$org$vfny$geoserver$wms$responses$GetMapResponse == null ? (class$org$vfny$geoserver$wms$responses$GetMapResponse = GetMapResponse.class$("org.vfny.geoserver.wms.responses.GetMapResponse")) : class$org$vfny$geoserver$wms$responses$GetMapResponse).getPackage().getName());
    private GetMapProducer delegate;
    private WMSMapContext map;
    private WMS wms;
    private HashMap responseHeaders;
    String headerContentDisposition;
    private ApplicationContext applicationContext;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$responses$GetMapResponse;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$GetMapProducerFactorySpi;

    public GetMapResponse(WMS wms, ApplicationContext applicationContext) {
        this.wms = wms;
        this.applicationContext = applicationContext;
        this.responseHeaders = new HashMap(10);
    }

    public HashMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public void execute(Request req) throws ServiceException {
        GetMapRequest request = (GetMapRequest)req;
        String outputFormat = request.getFormat();
        this.delegate = this.getDelegate(outputFormat, this.wms);
        this.map = new WMSMapContext(request);
        this.delegate.setMapContext(this.map);
        if (MetatileMapProducer.isRequestTiled(request, this.delegate)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Tiled request detected, activating on the fly meta tiler");
            }
            this.delegate = new MetatileMapProducer(request, (RasterMapProducer)this.delegate);
            this.delegate.setMapContext(this.map);
        }
        MapLayerInfo[] layers = request.getLayers();
        Style[] styles = request.getStyles().toArray(new Style[0]);
        Filter[] filters = request.getFilter() != null ? request.getFilter().toArray(new Filter[0]) : null;
        Envelope env = request.getBbox();
        if (env == null) {
            throw new WmsException("GetMap requests must include a BBOX parameter.");
        }
        if (env.isNull() || env.getWidth() <= 0.0 || env.getHeight() <= 0.0) {
            throw new WmsException("The request bounding box has zero area: " + env);
        }
        CoordinateReferenceSystem mapcrs = request.getCrs();
        if (mapcrs != null) {
            this.map.setAreaOfInterest(env, mapcrs);
        } else {
            this.map.setAreaOfInterest(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        this.map.setMapWidth(request.getWidth());
        this.map.setMapHeight(request.getHeight());
        this.map.setBgColor(request.getBgColor());
        this.map.setTransparent(request.isTransparent());
        this.map.setBuffer(request.getBuffer());
        this.map.setPaletteInverter(request.getPalette());
        if (request.getWidth() <= 0 || request.getHeight() <= 0 || this.map.getAreaOfInterest().getLength(0) <= 0.0 || this.map.getAreaOfInterest().getLength(1) <= 0.0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("We are not going to render anything because either the are is null ar the dimensions are not positive.");
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up map");
        }
        try {
            String contentDisposition;
            boolean cachingPossible = request.getHttpServletRequest().getMethod().equals("GET");
            String featureVersion = request.getFeatureVersion();
            int maxAge = Integer.MAX_VALUE;
            int length = layers.length;
            for (int i = 0; i < length; ++i) {
                DefaultMapLayer layer;
                FeatureSource source;
                Filter optionalFilter;
                Style style = styles[i];
                try {
                    optionalFilter = filters[i];
                }
                catch (Exception e) {
                    optionalFilter = null;
                }
                if (layers[i].getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
                    DefaultQuery definitionQuery;
                    cachingPossible = false;
                    source = layers[i].getRemoteFeatureSource();
                    layer = new DefaultMapLayer(source, style);
                    layer.setTitle(layers[i].getName());
                    if (optionalFilter != null) {
                        definitionQuery = new DefaultQuery(source.getSchema().getTypeName(), optionalFilter);
                        definitionQuery.setVersion(featureVersion);
                        layer.setQuery((Query)definitionQuery);
                    } else if (featureVersion != null) {
                        definitionQuery = new DefaultQuery(source.getSchema().getTypeName());
                        definitionQuery.setVersion(featureVersion);
                        layer.setQuery((Query)definitionQuery);
                    }
                    this.map.addLayer((MapLayer)layer);
                    continue;
                }
                if (layers[i].getType() == MapLayerInfo.TYPE_VECTOR) {
                    DefaultQuery definitionQuery;
                    if (cachingPossible) {
                        if (layers[i].getFeature().isCachingEnabled()) {
                            int nma = Integer.parseInt(layers[i].getFeature().getCacheMaxAge());
                            if (nma < maxAge) {
                                maxAge = nma;
                            }
                        } else {
                            cachingPossible = false;
                        }
                    }
                    try {
                        source = layers[i].getFeature().getFeatureSource(true);
                    }
                    catch (IOException exp) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, "Getting feature source: " + exp.getMessage(), exp);
                        }
                        throw new WmsException(null, "Internal error : " + exp.getMessage());
                    }
                    layer = new DefaultMapLayer(source, style);
                    layer.setTitle(layers[i].getName());
                    Filter definitionFilter = layers[i].getFeature().getDefinitionQuery();
                    if (definitionFilter != null) {
                        definitionQuery = new DefaultQuery(source.getSchema().getTypeName(), definitionFilter);
                        definitionQuery.setVersion(featureVersion);
                        layer.setQuery((Query)definitionQuery);
                    } else if (optionalFilter != null) {
                        definitionQuery = new DefaultQuery(source.getSchema().getTypeName(), optionalFilter);
                        definitionQuery.setVersion(featureVersion);
                        layer.setQuery((Query)definitionQuery);
                    } else if (featureVersion != null) {
                        definitionQuery = new DefaultQuery(source.getSchema().getTypeName());
                        definitionQuery.setVersion(featureVersion);
                        layer.setQuery((Query)definitionQuery);
                    }
                    this.map.addLayer((MapLayer)layer);
                    continue;
                }
                if (layers[i].getType() != MapLayerInfo.TYPE_RASTER) continue;
                AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)layers[i].getCoverage().getReader();
                if (reader != null) {
                    try {
                        ParameterValue time = reader.getFormat().getReadParameters().parameter("TIME");
                        if (time != null && request.getTime() != null) {
                            time.setValue((Object)request.getTime());
                        }
                    }
                    catch (ParameterNotFoundException p) {
                        // empty catch block
                    }
                    try {
                        ParameterValue elevation = reader.getFormat().getReadParameters().parameter("ELEVATION");
                        if (elevation != null && request.getElevation() != null) {
                            elevation.setValue(request.getElevation().intValue());
                        }
                    }
                    catch (ParameterNotFoundException p) {
                        // empty catch block
                    }
                    try {
                        ParameterValueGroup params = reader.getFormat().getReadParameters();
                        layer = new DefaultMapLayer(FeatureUtilities.wrapGridCoverageReader((AbstractGridCoverage2DReader)reader, (GeneralParameterValue[])CoverageUtils.getParameters((ParameterValueGroup)params, (Map)layers[i].getCoverage().getParameters())), style);
                        layer.setTitle(layers[i].getName());
                        layer.setQuery(Query.ALL);
                        this.map.addLayer((MapLayer)layer);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, "Wrapping GC in feature source: " + e.getLocalizedMessage(), e);
                        }
                        throw new WmsException(null, "Internal error : unable to get reader for this coverage layer " + layers[i].toString());
                    }
                }
                throw new WmsException(null, "Internal error : unable to get reader for this coverage layer " + layers[i].toString());
            }
            this.delegate.produceMap();
            if (cachingPossible) {
                this.responseHeaders.put("Cache-Control", "max-age=" + maxAge + ", must-revalidate");
            }
            if ((contentDisposition = this.delegate.getContentDisposition()) != null) {
                this.headerContentDisposition = contentDisposition;
            }
        }
        catch (Exception e) {
            this.clearMapContext();
            throw new WmsException(e, "Internal error ", "");
        }
    }

    public String getContentType(GeoServer gs) throws IllegalStateException {
        if (this.delegate == null) {
            throw new IllegalStateException("No request has been processed");
        }
        return this.delegate.getContentType();
    }

    public String getContentEncoding() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("returning content encoding null");
        }
        return null;
    }

    public void abort(Service gs) {
        if (this.delegate != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("asking delegate for aborting the process");
            }
            this.delegate.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws ServiceException, IOException {
        try {
            if (this.delegate == null) {
                throw new IllegalStateException("No GetMapDelegate is setted, make sure you have called execute and it has succeed");
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("asking delegate for write to " + out);
            }
            this.delegate.writeTo(out);
        }
        finally {
            this.clearMapContext();
        }
    }

    void clearMapContext() {
        block3: {
            try {
                if (this.map != null && this.map.getLayerCount() > 0) {
                    this.map.clearLayerList();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, "Getting feature source: " + e.getMessage(), e);
            }
        }
    }

    private GetMapProducer getDelegate(String outputFormat, WMS wms) throws WmsException {
        List producers = GeoServerExtensions.extensions((Class)(class$org$vfny$geoserver$wms$GetMapProducerFactorySpi == null ? (class$org$vfny$geoserver$wms$GetMapProducerFactorySpi = GetMapResponse.class$("org.vfny.geoserver.wms.GetMapProducerFactorySpi")) : class$org$vfny$geoserver$wms$GetMapProducerFactorySpi));
        Iterator iter = producers.iterator();
        while (iter.hasNext()) {
            GetMapProducerFactorySpi factory = (GetMapProducerFactorySpi)iter.next();
            if (!factory.canProduce(outputFormat)) continue;
            return factory.createMapProducer(outputFormat, wms);
        }
        WmsException e = new WmsException("There is no support for creating maps in " + outputFormat + " format");
        e.setCode("InvalidFormat");
        throw e;
    }

    public Set getMapFormats() {
        Set wmsGetMapFormats = GetMapResponse.loadImageFormats(this.applicationContext);
        return wmsGetMapFormats;
    }

    public static Set loadImageFormats(ApplicationContext applicationContext) {
        List producers = GeoServerExtensions.extensions((Class)(class$org$vfny$geoserver$wms$GetMapProducerFactorySpi == null ? (class$org$vfny$geoserver$wms$GetMapProducerFactorySpi = GetMapResponse.class$("org.vfny.geoserver.wms.GetMapProducerFactorySpi")) : class$org$vfny$geoserver$wms$GetMapProducerFactorySpi));
        HashSet formats = new HashSet();
        Iterator iter = producers.iterator();
        while (iter.hasNext()) {
            GetMapProducerFactorySpi producer = (GetMapProducerFactorySpi)iter.next();
            formats.addAll(producer.getSupportedFormats());
        }
        return Collections.unmodifiableSet(formats);
    }

    public String getContentDisposition() {
        return this.headerContentDisposition;
    }

    protected void finalize() throws Throwable {
        this.clearMapContext();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

