/* Copyright (c) 2001, 2007 TOPP - www.openplans.org. All rights reserved.
 * This code is licensed under the GPL 2.0 license, availible at the root
 * application directory.
 */
package org.vfny.geoserver.wms.responses;

import org.vfny.geoserver.wms.RasterMapProducer;
import java.awt.image.RenderedImage;


/**
 *
 * @author Simone Giannecchini, GeoSolutions
 *
 */
public abstract class AbstractRasterMapProducer extends AbstractGetMapProducer
    implements RasterMapProducer {
    /**
     * The image generated by the execute method.
     */
    protected RenderedImage image;

    public AbstractRasterMapProducer(String outputFormat, String mime) {
        super(outputFormat, mime);
    }

    /**
    * This is a package protected method with the sole purpose of facilitate
    * unit testing. Do not use by any means for oher purposes.
    *
    * @return DOCUMENT ME!
    */
    public RenderedImage getImage() {
        return this.image;
    }
}
