/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.tiff;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.responses.map.tiff.TiffMapProducer;

public final class TiffMapProducerFactory
implements GetMapProducerFactorySpi {
    static final String MIME_TYPE = "image/tiff";
    private static final Set SUPPORTED_FORMATS = new HashSet(2);
    private static final Logger LOGGER;

    public String getName() {
        return "Tiff backed raster maps producer";
    }

    public Set getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    public boolean isAvailable() {
        try {
            Class.forName("com.sun.media.imageio.plugins.tiff.TIFFImageWriteParam");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canProduce(String mapFormat) {
        return SUPPORTED_FORMATS.contains(mapFormat);
    }

    public GetMapProducer createMapProducer(String mapFormat, WMS wms) throws IllegalArgumentException {
        if (!this.canProduce(mapFormat)) {
            throw new IllegalArgumentException("Can't produce " + mapFormat + " format");
        }
        return new TiffMapProducer(mapFormat, MIME_TYPE, wms);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    static {
        SUPPORTED_FORMATS.add(MIME_TYPE);
        SUPPORTED_FORMATS.add("image/tiff8");
        LOGGER = Logger.getLogger("org.vfny.geoserver.wms.responses.map.tiff");
    }
}

