/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.helpers;

import java.util.Iterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class DescribeLayerTransformer
extends TransformerBase {
    private String schemaBaseUrl;

    public DescribeLayerTransformer(String schemaBaseUrl) {
        if (schemaBaseUrl == null) {
            throw new NullPointerException();
        }
        this.schemaBaseUrl = schemaBaseUrl;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new DescribeLayerTranslator(handler);
    }

    public Transformer createTransformer() throws TransformerException {
        Transformer transformer = super.createTransformer();
        String dtdUrl = this.schemaBaseUrl + "wms/1.1.1/WMS_DescribeLayerResponse.dtd";
        transformer.setOutputProperty("doctype-system", dtdUrl);
        return transformer;
    }

    private static class DescribeLayerTranslator
    extends TransformerBase.TranslatorSupport {
        public DescribeLayerTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof DescribeLayerRequest)) {
                throw new IllegalArgumentException();
            }
            DescribeLayerRequest req = (DescribeLayerRequest)((Object)o);
            AttributesImpl version = new AttributesImpl();
            version.addAttribute("", "version", "version", "", "1.0.0");
            this.start("WMS_DescribeLayerResponse", version);
            this.handleLayers(req);
            this.end("WMS_DescribeLayerResponse");
        }

        private void handleLayers(DescribeLayerRequest req) {
            String url = req.getBaseUrl() + "wfs/WfsDispatcher?";
            AttributesImpl layerAtts = new AttributesImpl();
            layerAtts.addAttribute("", "name", "name", "", "");
            layerAtts.addAttribute("", "wfs", "wfs", "", url);
            AttributesImpl queryAtts = new AttributesImpl();
            queryAtts.addAttribute("", "typeName", "typeName", "", "");
            Iterator it = req.getLayers().iterator();
            while (it.hasNext()) {
                MapLayerInfo layer = (MapLayerInfo)((Object)it.next());
                layerAtts.setAttribute(0, "", "name", "name", "", layer.getName());
                this.start("LayerDescription", layerAtts);
                queryAtts.setAttribute(0, "", "typeName", "typeName", "", layer.getName());
                this.element("Query", null, queryAtts);
                this.end("LayerDescription");
            }
        }
    }
}

