/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.BandMergeDescriptor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.map.MapContext;
import org.geotools.renderer.lite.StreamingRenderer;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.RasterMapProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.AbstractRasterMapProducer;
import org.vfny.geoserver.wms.responses.palette.CustomPaletteBuilder;
import org.vfny.geoserver.wms.responses.palette.InverseColorMapOp;

public abstract class DefaultRasterMapProducer
extends AbstractRasterMapProducer
implements RasterMapProducer {
    public static final Interpolation NN_INTERPOLATION = new InterpolationNearest();
    public static final Interpolation BIL_INTERPOLATION = new InterpolationBilinear();
    public static final Interpolation BIC_INTERPOLATION = new InterpolationBicubic2(0);
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map");
    private static final String DEFAULT_MAP_FORMAT = "image/png";
    private WMS wms;

    public DefaultRasterMapProducer() {
        this(DEFAULT_MAP_FORMAT, (WMS)null);
    }

    public DefaultRasterMapProducer(WMS wms) {
        this(DEFAULT_MAP_FORMAT, wms);
    }

    public DefaultRasterMapProducer(String outputFormat, WMS wms) {
        this(outputFormat, outputFormat, wms);
    }

    public DefaultRasterMapProducer(String outputFormat, String mime, WMS wms) {
        super(outputFormat, mime);
        this.wms = wms;
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        this.formatImageOutputStream(this.image, out);
    }

    /*
     * WARNING - void declaration
     */
    public void produceMap() throws WmsException {
        void var5_5;
        Graphics2D graphic;
        InverseColorMapOp paletteInverter;
        RenderedImage preparedImage;
        int width = this.mapContext.getMapWidth();
        int height = this.mapContext.getMapHeight();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up " + width + "x" + height + " image");
        }
        if ((preparedImage = this.prepareImage(width, height, (paletteInverter = this.mapContext.getPaletteInverter()) != null ? paletteInverter.getIcm() : null)) instanceof BufferedImage) {
            graphic = ((BufferedImage)preparedImage).createGraphics();
        } else if (preparedImage instanceof TiledImage) {
            graphic = ((TiledImage)preparedImage).createGraphics();
        } else if (preparedImage instanceof VolatileImage) {
            graphic = ((VolatileImage)((Object)preparedImage)).createGraphics();
        } else {
            throw new WmsException("Unrecognized back-end image type");
        }
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.wms != null && "Nearest".equals(this.wms.getAllowInterpolation())) {
            hintsMap.put(JAI.KEY_INTERPOLATION, NN_INTERPOLATION);
        } else if (this.wms != null && "Bilinear".equals(this.wms.getAllowInterpolation())) {
            hintsMap.put(JAI.KEY_INTERPOLATION, BIL_INTERPOLATION);
        } else if (this.wms != null && "Bicubic".equals(this.wms.getAllowInterpolation())) {
            hintsMap.put(JAI.KEY_INTERPOLATION, BIC_INTERPOLATION);
        }
        var5_5.setRenderingHints(hintsMap);
        if (!this.mapContext.isTransparent()) {
            var5_5.setColor(this.mapContext.getBgColor());
            var5_5.fillRect(0, 0, width, height);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("setting to transparent");
            }
            int type = 2;
            var5_5.setComposite(AlphaComposite.getInstance(type));
            Color c = new Color(this.mapContext.getBgColor().getRed(), this.mapContext.getBgColor().getGreen(), this.mapContext.getBgColor().getBlue(), 0);
            var5_5.setBackground(this.mapContext.getBgColor());
            var5_5.setColor(c);
            var5_5.fillRect(0, 0, width, height);
            type = 3;
            var5_5.setComposite(AlphaComposite.getInstance(type));
        }
        Rectangle paintArea = new Rectangle(width, height);
        RenderingHints hints = new RenderingHints(hintsMap);
        this.renderer = new StreamingRenderer();
        this.renderer.setContext((MapContext)this.mapContext);
        this.renderer.setJava2DHints(hints);
        HashMap<String, Comparable<Boolean>> rendererParams = new HashMap<String, Comparable<Boolean>>();
        rendererParams.put("optimizedDataLoadingEnabled", new Boolean(true));
        rendererParams.put("renderingBuffer", new Integer(this.mapContext.getBuffer()));
        this.renderer.setRendererHints(rendererParams);
        ReferencedEnvelope dataArea = this.mapContext.getAreaOfInterest();
        if (this.abortRequested) {
            var5_5.dispose();
            return;
        }
        this.renderer.paint((Graphics2D)var5_5, paintArea, dataArea);
        var5_5.dispose();
        if (!this.abortRequested) {
            this.image = preparedImage;
        }
    }

    protected RenderedImage prepareImage(int width, int height, IndexColorModel palette) {
        return new BufferedImage(width, height, 6);
    }

    protected RenderedImage forceIndexed8Bitmask(RenderedImage originalImage) {
        RenderedImage image;
        boolean dataTypeByte;
        ColorModel cm = originalImage.getColorModel();
        boolean bl = dataTypeByte = originalImage.getSampleModel().getDataType() == 0;
        if (cm instanceof IndexColorModel && dataTypeByte) {
            IndexColorModel icm = (IndexColorModel)cm;
            image = icm.getTransparency() != 3 ? originalImage : new ImageWorker(originalImage).forceBitmaskIndexColorModel().getRenderedImage();
        } else {
            InverseColorMapOp invColorMap = this.getMapContext().getPaletteInverter();
            if (invColorMap != null) {
                image = invColorMap.filterRenderedImage(originalImage);
            } else {
                image = new ImageWorker(originalImage).forceComponentColorModel().getRenderedImage();
                if (originalImage.getColorModel().hasAlpha()) {
                    RenderedImage alpha = new ImageWorker(originalImage).retainLastBand().multiplyConst(new double[]{255.0}).retainFirstBand().getRenderedImage();
                    int numBands = originalImage.getSampleModel().getNumBands();
                    originalImage = new ImageWorker(originalImage).retainBands(numBands - 1).getRenderedImage();
                    ImageLayout layout = new ImageLayout();
                    if (numBands == 4) {
                        layout.setColorModel((ColorModel)new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 2, 0));
                    } else {
                        layout.setColorModel((ColorModel)new ComponentColorModel(ColorSpace.getInstance(1003), true, false, 2, 0));
                    }
                    image = BandMergeDescriptor.create((RenderedImage)originalImage, (RenderedImage)alpha, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout)).getNewRendering();
                } else {
                    image = originalImage;
                }
                int subsx = (int)Math.pow(2.0, image.getWidth() / 256);
                int subsy = (int)Math.pow(2.0, image.getHeight() / 256);
                image = new CustomPaletteBuilder(image, 255, subsx, subsy).buildPalette().getIndexedImage();
            }
        }
        return image;
    }
}

