/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.util.Range;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.renderer.lite.LiteShape2;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.wms.GetLegendGraphicProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;

public abstract class DefaultRasterLegendProducer
implements GetLegendGraphicProducer {
    private static final Logger LOGGER = Logger.getLogger((class$org$vfny$geoserver$wms$responses$DefaultRasterLegendProducer == null ? (class$org$vfny$geoserver$wms$responses$DefaultRasterLegendProducer = DefaultRasterLegendProducer.class$("org.vfny.geoserver.wms.responses.DefaultRasterLegendProducer")) : class$org$vfny$geoserver$wms$responses$DefaultRasterLegendProducer).getPackage().getName());
    private static final SLDStyleFactory styleFactory = new SLDStyleFactory();
    private static final double TOLERANCE = 1.0E-6;
    private static final StyledShapePainter shapePainter = new StyledShapePainter(null);
    private static final GeometryFactory geomFac = new GeometryFactory();
    public static final Color BG_COLOR = Color.WHITE;
    public static final Color FONT_COLOR = Color.BLACK;
    private static final ImageObserver imgObs = new Canvas();
    private static final float hpaddingFactor = 0.15f;
    private static final float vpaddingFactor = 0.15f;
    private BufferedImage legendGraphic;
    private boolean renderingStopRequested;
    private LiteShape2 sampleRect;
    private LiteShape2 sampleLine;
    private LiteShape2 samplePoint;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$responses$DefaultRasterLegendProducer;

    public void produceLegendGraphic(GetLegendGraphicRequest request) throws WmsException {
        Feature sampleFeature = this.createSampleFeature(request.getLayer());
        Style gt2Style = request.getStyle();
        FeatureTypeStyle[] ftStyles = gt2Style.getFeatureTypeStyles();
        double scaleDenominator = request.getScale();
        Rule[] applicableRules = request.getRule() != null ? new Rule[]{request.getRule()} : this.getApplicableRules(ftStyles, scaleDenominator);
        NumberRange scaleRange = new NumberRange(scaleDenominator, scaleDenominator);
        int ruleCount = applicableRules.length;
        ArrayList<BufferedImage> legendsStack = new ArrayList<BufferedImage>(ruleCount);
        int w = request.getWidth();
        int h = request.getHeight();
        Color bgColor = DefaultRasterLegendProducer.getBackgroundColor(request);
        for (int i = 0; i < ruleCount; ++i) {
            Symbolizer[] symbolizers = applicableRules[i].getSymbolizers();
            BufferedImage image = new BufferedImage(w, h, 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(bgColor);
            graphics.fillRect(0, 0, w, h);
            for (int sIdx = 0; sIdx < symbolizers.length; ++sIdx) {
                Symbolizer symbolizer = symbolizers[sIdx];
                if (symbolizer instanceof RasterSymbolizer) {
                    BufferedImage imgShape = new BufferedImage(w, h, 2);
                    try {
                        imgShape = ImageIO.read(new URL(request.getHttpServletRequest().getRequestURL() + "/../data/images/rasterLegend.png"));
                    }
                    catch (MalformedURLException e) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        throw new WmsException(e);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        throw new WmsException(e);
                    }
                    graphics.drawImage(imgShape, 0, 0, w, h, null);
                    continue;
                }
                Style2D style2d = styleFactory.createStyle(sampleFeature, symbolizer, (Range)scaleRange);
                LiteShape2 shape = this.getSampleShape(symbolizer, w, h);
                if (style2d == null) continue;
                shapePainter.paint(graphics, shape, style2d, scaleDenominator);
            }
            legendsStack.add(image);
        }
        this.legendGraphic = DefaultRasterLegendProducer.mergeLegends(legendsStack, applicableRules, request);
    }

    private BufferedImage scaleImage(BufferedImage image, GetLegendGraphicRequest request) {
        int w = request.getWidth();
        int h = request.getHeight();
        BufferedImage scaledImage = new BufferedImage(w, h, 2);
        Graphics2D graphics = scaledImage.createGraphics();
        graphics.setColor(DefaultRasterLegendProducer.getBackgroundColor(request));
        graphics.fillRect(0, 0, w, h);
        AffineTransform xform = new AffineTransform();
        xform.setToScale((double)w / (double)image.getWidth(), (double)h / (double)image.getHeight());
        graphics.drawImage(image, xform, null);
        return scaledImage;
    }

    private static BufferedImage mergeLegends(List imageStack, Rule[] rules, GetLegendGraphicRequest req) {
        String aaVal;
        Font labelFont = DefaultRasterLegendProducer.getLabelFont(req);
        boolean useAA = false;
        if (req.getLegendOptions().get("fontAntiAliasing") instanceof String && ((aaVal = (String)req.getLegendOptions().get("fontAntiAliasing")).equalsIgnoreCase("on") || aaVal.equalsIgnoreCase("true") || aaVal.equalsIgnoreCase("yes") || aaVal.equalsIgnoreCase("1"))) {
            useAA = true;
        }
        boolean forceLabelsOn = false;
        boolean forceLabelsOff = false;
        if (req.getLegendOptions().get("forceLabels") instanceof String) {
            String forceLabelsOpt = (String)req.getLegendOptions().get("forceLabels");
            if (forceLabelsOpt.equalsIgnoreCase("on")) {
                forceLabelsOn = true;
            } else if (forceLabelsOpt.equalsIgnoreCase("off")) {
                forceLabelsOff = true;
            }
        }
        if (imageStack.size() == 0) {
            throw new IllegalArgumentException("No legend graphics passed");
        }
        BufferedImage finalLegend = null;
        if (imageStack.size() == 1 && !forceLabelsOn) {
            finalLegend = (BufferedImage)imageStack.get(0);
        } else {
            int imgCount = imageStack.size();
            String[] labels = new String[imgCount];
            BufferedImage img = (BufferedImage)imageStack.get(0);
            int totalHeight = 0;
            int totalWidth = 0;
            int[] rowHeights = new int[imgCount];
            for (int i = 0; i < imgCount; ++i) {
                img = (BufferedImage)imageStack.get(i);
                if (forceLabelsOff) {
                    totalWidth = (int)Math.ceil(Math.max(img.getWidth(), totalWidth));
                    rowHeights[i] = img.getHeight();
                    totalHeight += img.getHeight();
                    continue;
                }
                Rule rule = rules[i];
                labels[i] = rule.getTitle();
                if (labels[i] == null) {
                    labels[i] = rule.getName();
                }
                if (labels[i] == null) {
                    labels[i] = "";
                }
                Graphics2D g = img.createGraphics();
                g.setFont(labelFont);
                if (useAA) {
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                }
                if (labels[i] != null && labels[i].length() > 0) {
                    BufferedImage renderedLabel = DefaultRasterLegendProducer.renderLabel(labels[i], g, req);
                    Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, renderedLabel.getWidth(), renderedLabel.getHeight());
                    totalWidth = (int)Math.ceil(Math.max((double)img.getWidth() + ((RectangularShape)bounds).getWidth(), (double)totalWidth));
                    rowHeights[i] = (int)Math.ceil(Math.max((double)img.getHeight(), ((RectangularShape)bounds).getHeight()));
                } else {
                    totalWidth = (int)Math.ceil(Math.max(img.getWidth(), totalWidth));
                    rowHeights[i] = (int)Math.ceil(img.getHeight());
                }
                totalHeight += rowHeights[i];
            }
            finalLegend = new BufferedImage(totalWidth += 2, totalHeight, 2);
            Graphics2D finalGraphics = finalLegend.createGraphics();
            finalGraphics.setColor(DefaultRasterLegendProducer.getBackgroundColor(req));
            finalGraphics.fillRect(0, 0, totalWidth, totalHeight);
            int topOfRow = 0;
            for (int i = 0; i < imgCount; ++i) {
                img = (BufferedImage)imageStack.get(i);
                int y = topOfRow;
                if (img.getHeight() < rowHeights[i]) {
                    y += (int)((double)(rowHeights[i] - img.getHeight()) / 2.0);
                }
                finalGraphics.drawImage((Image)img, 0, y, imgObs);
                if (forceLabelsOff) {
                    topOfRow += rowHeights[i];
                    continue;
                }
                finalGraphics.setFont(labelFont);
                if (useAA) {
                    finalGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                } else {
                    finalGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                }
                if (labels[i] != null && labels[i].length() > 0) {
                    BufferedImage renderedLabel = DefaultRasterLegendProducer.renderLabel(labels[i], finalGraphics, req);
                    y = topOfRow;
                    if (renderedLabel.getHeight() < rowHeights[i]) {
                        y += (int)((double)(rowHeights[i] - renderedLabel.getHeight()) / 2.0);
                    }
                    finalGraphics.drawImage((Image)renderedLabel, img.getWidth(), y, imgObs);
                }
                topOfRow += rowHeights[i];
            }
        }
        return finalLegend;
    }

    private static Font getLabelFont(GetLegendGraphicRequest req) {
        String legendFontName = "Sans-Serif";
        String legendFontFamily = "plain";
        int legendFontSize = 12;
        Map legendOptions = req.getLegendOptions();
        if (legendOptions.get("fontName") != null) {
            legendFontName = (String)legendOptions.get("fontName");
        }
        if (legendOptions.get("fontStyle") != null) {
            legendFontFamily = (String)legendOptions.get("fontStyle");
        }
        if (legendOptions.get("fontSize") != null) {
            try {
                legendFontSize = Integer.parseInt((String)legendOptions.get("fontSize"));
            }
            catch (Exception e) {
                LOGGER.warning("Error trying to interpret legendOption 'fontSize': " + legendOptions.get("fontSize"));
            }
        }
        Font legendFont = legendFontFamily.equalsIgnoreCase("italic") ? new Font(legendFontName, 2, legendFontSize) : (legendFontFamily.equalsIgnoreCase("bold") ? new Font(legendFontName, 1, legendFontSize) : new Font(legendFontName, 0, legendFontSize));
        return legendFont;
    }

    private static Color getLabelFontColor(GetLegendGraphicRequest req) {
        Map legendOptions = req.getLegendOptions();
        String color = (String)legendOptions.get("fontColor");
        if (color == null) {
            return FONT_COLOR;
        }
        try {
            return DefaultRasterLegendProducer.color(color);
        }
        catch (NumberFormatException e) {
            LOGGER.warning("Could not decode label color: " + color + ", default to " + FONT_COLOR.toString());
            return FONT_COLOR;
        }
    }

    private static Color getBackgroundColor(GetLegendGraphicRequest req) {
        Map legendOptions = req.getLegendOptions();
        String color = (String)legendOptions.get("bgColor");
        if (color == null) {
            return BG_COLOR;
        }
        try {
            return DefaultRasterLegendProducer.color(color);
        }
        catch (NumberFormatException e) {
            LOGGER.warning("Could not decode background color: " + color + ", default to " + BG_COLOR.toString());
            return BG_COLOR;
        }
    }

    private static Color color(String hex) throws NumberFormatException {
        if (!hex.startsWith("#")) {
            hex = "#" + hex;
        }
        return Color.decode(hex);
    }

    public static BufferedImage renderLabel(String label, Graphics2D g, GetLegendGraphicRequest req) {
        BufferedImage renderedLabel;
        Color labelColor = DefaultRasterLegendProducer.getLabelFontColor(req);
        if (label.indexOf("\n") != -1 || label.indexOf("\\n") != -1) {
            Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            ArrayList<Integer> lineHeight = new ArrayList<Integer>();
            String realLabel = label.replaceAll("\\\\n", "\n");
            StringTokenizer st = new StringTokenizer(realLabel, "\n\r\f");
            while (st.hasMoreElements()) {
                String token = st.nextToken();
                Rectangle2D thisLineBounds = g.getFontMetrics().getStringBounds(token, g);
                int thisLineHeight = (int)Math.ceil(thisLineBounds.getHeight());
                bounds.add(0.0, (double)thisLineHeight + ((RectangularShape)bounds).getHeight());
                bounds.add(thisLineBounds.getWidth(), 0.0);
                lineHeight.add(new Integer((int)Math.ceil(thisLineBounds.getHeight())));
            }
            renderedLabel = new BufferedImage((int)Math.ceil(((RectangularShape)bounds).getWidth()), (int)Math.ceil(((RectangularShape)bounds).getHeight()), 2);
            st = new StringTokenizer(realLabel, "\n\r\f");
            Graphics2D rlg = renderedLabel.createGraphics();
            rlg.setColor(labelColor);
            rlg.setFont(g.getFont());
            rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
            int y = 0 - g.getFontMetrics().getDescent();
            int c = 0;
            while (st.hasMoreElements()) {
                rlg.drawString(st.nextToken(), 0, y += ((Integer)lineHeight.get(c++)).intValue());
            }
        } else {
            int height = (int)Math.ceil(g.getFontMetrics().getStringBounds(label, g).getHeight());
            int width = (int)Math.ceil(g.getFontMetrics().getStringBounds(label, g).getWidth());
            renderedLabel = new BufferedImage(width, height, 2);
            Graphics2D rlg = renderedLabel.createGraphics();
            rlg.setColor(labelColor);
            rlg.setFont(g.getFont());
            rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
            rlg.drawString(label, 0, height - rlg.getFontMetrics().getDescent());
        }
        return renderedLabel;
    }

    /*
     * WARNING - void declaration
     */
    private LiteShape2 getSampleShape(Symbolizer symbolizer, int legendWidth, int legendHeight) {
        void var4_14;
        LiteShape2 sampleShape;
        float hpad = (float)legendWidth * 0.15f;
        float vpad = (float)legendHeight * 0.15f;
        if (symbolizer instanceof LineSymbolizer) {
            if (this.sampleLine == null) {
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)((float)legendHeight - vpad)), new Coordinate((double)((float)legendWidth - hpad), (double)vpad)};
                LineString geom = geomFac.createLineString(coords);
                try {
                    this.sampleLine = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleLine = null;
                }
            }
            sampleShape = this.sampleLine;
        } else if (symbolizer instanceof PolygonSymbolizer || symbolizer instanceof RasterSymbolizer) {
            if (this.sampleRect == null) {
                float w = (float)legendWidth - 2.0f * hpad;
                float h = (float)legendHeight - 2.0f * vpad;
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)vpad), new Coordinate((double)hpad, (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)vpad), new Coordinate((double)hpad, (double)vpad)};
                LinearRing shell = geomFac.createLinearRing(coords);
                Polygon geom = geomFac.createPolygon(shell, null);
                try {
                    this.sampleRect = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleRect = null;
                }
            }
            sampleShape = this.sampleRect;
        } else if (symbolizer instanceof PointSymbolizer || symbolizer instanceof TextSymbolizer) {
            if (this.samplePoint == null) {
                Coordinate coord = new Coordinate((double)(legendWidth / 2), (double)(legendHeight / 2));
                try {
                    this.samplePoint = new LiteShape2((Geometry)geomFac.createPoint(coord), null, null, false);
                }
                catch (Exception e) {
                    this.samplePoint = null;
                }
            }
            sampleShape = this.samplePoint;
        } else {
            throw new IllegalArgumentException("Unknown symbolizer: " + symbolizer);
        }
        return var4_14;
    }

    private Feature createSampleFeature(FeatureType schema) throws WmsException {
        Feature sampleFeature;
        try {
            AttributeType[] atts = schema.getAttributeTypes();
            Object[] attributes = new Object[atts.length];
            for (int i = 0; i < atts.length; ++i) {
                attributes[i] = atts[i].createDefaultValue();
            }
            sampleFeature = schema.create(attributes);
        }
        catch (IllegalAttributeException e) {
            e.printStackTrace();
            throw new WmsException(e);
        }
        return sampleFeature;
    }

    private Rule[] getApplicableRules(FeatureTypeStyle[] ftStyles, double scaleDenominator) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        for (int i = 0; i < ftStyles.length; ++i) {
            FeatureTypeStyle fts = ftStyles[i];
            Rule[] rules = fts.getRules();
            for (int j = 0; j < rules.length; ++j) {
                Rule r = rules[j];
                if (!this.isWithInScale(r, scaleDenominator)) continue;
                ruleList.add(r);
            }
        }
        return ruleList.toArray(new Rule[ruleList.size()]);
    }

    private boolean isWithInScale(Rule r, double scaleDenominator) {
        return scaleDenominator == -1.0 || r.getMinScaleDenominator() - 1.0E-6 <= scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > scaleDenominator;
    }

    public BufferedImage getLegendGraphic() {
        if (this.legendGraphic == null) {
            throw new IllegalStateException();
        }
        return this.legendGraphic;
    }

    public void abort() {
        this.renderingStopRequested = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ String getContentType() throws IllegalStateException;

    public abstract /* synthetic */ void writeTo(OutputStream var1) throws IOException, ServiceException;
}

