/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.IOException;
import org.geotools.data.FeatureSource;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.Style;
import org.opengis.spatialschema.geometry.Envelope;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.dto.CoverageInfoDTO;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.util.DataStoreUtils;

public final class MapLayerInfo
extends GlobalLayerSupertype {
    public static int TYPE_VECTOR = Data.TYPE_VECTOR;
    public static int TYPE_RASTER = Data.TYPE_RASTER;
    private FeatureTypeInfo feature;
    private CoverageInfo coverage;
    private int type;
    private String name;
    private String label;
    private String description;
    private String dirName;

    public MapLayerInfo() {
        this.name = "";
        this.label = "";
        this.description = "";
        this.dirName = "";
        this.coverage = null;
        this.feature = null;
        this.type = -1;
    }

    public MapLayerInfo(CoverageInfoDTO dto, Data data) throws ConfigurationException {
        this.name = dto.getName();
        this.label = dto.getLabel();
        this.description = dto.getDescription();
        this.dirName = dto.getDirName();
        this.coverage = new CoverageInfo(dto, data);
        this.feature = null;
        this.type = TYPE_RASTER;
    }

    public MapLayerInfo(FeatureTypeInfoDTO dto, Data data) throws ConfigurationException {
        this.name = dto.getName();
        this.label = dto.getTitle();
        this.description = dto.getAbstract();
        this.dirName = dto.getDirName();
        this.feature = new FeatureTypeInfo(dto, data);
        this.coverage = null;
        this.type = TYPE_VECTOR;
    }

    Object toDTO() {
        return null;
    }

    public com.vividsolutions.jts.geom.Envelope getBoundingBox() throws IOException {
        if (this.type == TYPE_VECTOR) {
            try {
                return this.feature.getBoundingBox();
            }
            catch (IllegalArgumentException e) {
                FeatureSource realSource = this.feature.getFeatureSource();
                return DataStoreUtils.getBoundingBoxEnvelope((FeatureSource)realSource);
            }
        }
        return new ReferencedEnvelope((Envelope)this.coverage.getEnvelope(), this.coverage.getCrs());
    }

    public com.vividsolutions.jts.geom.Envelope getLatLongBoundingBox() throws IOException {
        if (this.type == TYPE_VECTOR) {
            try {
                return this.feature.getLatLongBoundingBox();
            }
            catch (IllegalArgumentException e) {
                FeatureSource realSource = this.feature.getFeatureSource();
                return DataStoreUtils.getBoundingBoxEnvelope((FeatureSource)realSource);
            }
        }
        GeneralEnvelope ge = this.coverage.getWGS84LonLatEnvelope();
        return new com.vividsolutions.jts.geom.Envelope(ge.getMinimum(0), ge.getMaximum(0), ge.getMinimum(1), ge.getMaximum(1));
    }

    public CoverageInfo getCoverage() {
        return this.coverage;
    }

    public void setCoverage(CoverageInfo coverage) {
        this.name = coverage.getName();
        this.label = coverage.getLabel();
        this.description = coverage.getDescription();
        this.dirName = coverage.getDirName();
        this.coverage = coverage;
        this.feature = null;
        this.type = TYPE_RASTER;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public FeatureTypeInfo getFeature() {
        return this.feature;
    }

    public void setFeature(FeatureTypeInfo feature) {
        try {
            this.name = feature.getName();
            this.label = feature.getTitle();
            this.description = feature.getAbstract();
            this.dirName = feature.getDirName();
        }
        catch (IllegalArgumentException e) {
            this.name = "";
            this.label = "";
            this.description = "";
            this.dirName = "";
        }
        this.feature = feature;
        this.coverage = null;
        this.type = TYPE_VECTOR;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Style getDefaultStyle() {
        if (this.type == TYPE_VECTOR) {
            return this.feature.getDefaultStyle();
        }
        if (this.type == TYPE_RASTER) {
            return this.coverage.getDefaultStyle();
        }
        return null;
    }
}

