/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.palette;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.TiledImage;
import org.vfny.geoserver.wms.responses.palette.EfficientInverseColorMapComputation;
import org.vfny.geoserver.wms.responses.palette.InverseColorMapRasterOp;

public final class InverseColorMapOp
implements BufferedImageOp {
    protected final InverseColorMapRasterOp rasterOp;
    protected final IndexColorModel icm;
    protected final int alphaThreshold;
    protected final boolean hasAlpha;
    protected final int transparencyIndex;

    public InverseColorMapOp(IndexColorModel destCM, int quantizationColors, int alphaThreshold) {
        this.rasterOp = new InverseColorMapRasterOp(destCM, quantizationColors, alphaThreshold);
        this.icm = destCM;
        this.alphaThreshold = alphaThreshold;
        this.hasAlpha = this.icm.hasAlpha();
        this.transparencyIndex = this.icm.getTransparentPixel();
    }

    public InverseColorMapOp(IndexColorModel destCM) {
        this(destCM, 5, 1);
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (!(destCM instanceof IndexColorModel) || ((IndexColorModel)destCM).getTransparency() == 3) {
            return null;
        }
        return new BufferedImage(src.getWidth(), src.getHeight(), 13, (IndexColorModel)destCM);
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        if (dest == null) {
            dest = new BufferedImage(src.getWidth(), src.getHeight(), 13, this.icm);
        } else {
            if (!(dest.getColorModel() instanceof IndexColorModel) || ((IndexColorModel)dest.getColorModel()).getTransparency() != this.transparencyIndex) {
                throw new IllegalArgumentException();
            }
            if (((IndexColorModel)dest.getColorModel()).getTransparentPixel() != this.transparencyIndex) {
                throw new IllegalArgumentException();
            }
        }
        WritableRaster wr = dest.getRaster();
        WritableRaster ir = src.getRaster();
        this.rasterOp.filter(ir, wr);
        return dest;
    }

    public BufferedImage filterRenderedImage(RenderedImage in) {
        if (in instanceof BufferedImage) {
            return this.filter((BufferedImage)in, null);
        }
        TiledImage src = new TiledImage(in, true);
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 13, this.icm);
        WritableRaster destWr = dest.getRaster();
        int minTileX = src.getMinTileX();
        int minTileY = src.getMinTileY();
        if (src.getNumXTiles() == 1 && src.getNumYTiles() == 1) {
            Raster sourceR = src.getTile(minTileX, minTileY);
            this.rasterOp.filter(sourceR.createChild(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight(), 0, 0, null), destWr);
            return dest;
        }
        int maxTileX = src.getNumXTiles() + minTileX;
        int maxTileY = src.getNumYTiles() + minTileY;
        int tileW = src.getTileWidth();
        int tileH = src.getTileHeight();
        int xx = 0;
        int srcW = src.getWidth();
        int[] rgba = new int[src.getSampleModel().getNumBands()];
        boolean sourceHasAlpha = rgba.length == 0;
        EfficientInverseColorMapComputation invCM = this.rasterOp.getInvCM();
        for (int ti = minTileX; ti < maxTileX; ++ti) {
            for (int tj = minTileY; tj < maxTileY; ++tj) {
                Raster r = src.getTile(ti, tj);
                int minx = r.getMinX();
                int miny = r.getMinY();
                int maxx = minx + tileW;
                int maxy = miny + tileH;
                for (int j = miny; j < maxy; ++j) {
                    for (int i = minx; i < maxx; ++i) {
                        for (int b = 0; b < rgba.length; ++b) {
                            rgba[b] = src.getSample(i, j, b);
                        }
                        if (sourceHasAlpha && this.hasAlpha && rgba[3] >= this.alphaThreshold || !this.hasAlpha) {
                            int val = invCM.getIndexNearest(rgba[0] & 0xFF, rgba[1] & 0xFF, rgba[2]);
                            if (this.hasAlpha && val >= this.transparencyIndex) {
                                ++val;
                            }
                            destWr.setSample(xx % srcW, xx / srcW, 0, val);
                        } else {
                            destWr.setSample(xx % srcW, xx / srcW, 0, this.transparencyIndex);
                        }
                        ++xx;
                    }
                }
            }
        }
        return dest;
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(src.getWidth(), src.getHeight());
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point();
        }
        dstPt.setLocation(srcPt);
        return dstPt;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public IndexColorModel getIcm() {
        return this.icm;
    }
}

