/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.map.MapLayer;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformerBase;
import org.vfny.geoserver.wms.responses.map.kml.KMLUtils;
import org.xml.sax.ContentHandler;

public class KMLRasterTransformer
extends KMLTransformerBase {
    final WMSMapContext mapContext;
    boolean inline = false;

    public KMLRasterTransformer(WMSMapContext mapContext) {
        this.mapContext = mapContext;
        this.setNamespaceDeclarationEnabled(false);
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLRasterTranslator(handler);
    }

    class KMLRasterTranslator
    extends KMLTransformerBase.KMLTranslatorSupport {
        public KMLRasterTranslator(ContentHandler handler) {
            super(KMLRasterTransformer.this, handler);
        }

        public void encode(Object o) throws IllegalArgumentException {
            MapLayer mapLayer = (MapLayer)o;
            int mapLayerOrder = KMLRasterTransformer.this.mapContext.indexOf(mapLayer);
            if (KMLRasterTransformer.this.isStandAlone()) {
                this.start("kml");
            }
            this.start("Folder");
            this.element("name", "layer_" + mapLayerOrder);
            this.element("description", mapLayer.getTitle());
            this.start("GroundOverlay");
            this.element("name", mapLayer.getTitle());
            this.element("drawOrder", Integer.toString(mapLayerOrder));
            this.start("Icon");
            this.encodeHref(mapLayer);
            this.element("viewRefreshMode", "never");
            this.element("viewBoundScale", "0.75");
            this.end("Icon");
            Envelope box = KMLRasterTransformer.this.mapContext.getRequest().getBbox();
            this.start("LatLonBox");
            this.element("north", Double.toString(box.getMaxY()));
            this.element("south", Double.toString(box.getMinY()));
            this.element("east", Double.toString(box.getMaxX()));
            this.element("west", Double.toString(box.getMinX()));
            this.end("LatLonBox");
            this.end("GroundOverlay");
            this.end("Folder");
            if (KMLRasterTransformer.this.isStandAlone()) {
                this.end("kml");
            }
        }

        protected void encodeHref(MapLayer mapLayer) {
            if (KMLRasterTransformer.this.inline) {
                int mapLayerOrder = KMLRasterTransformer.this.mapContext.indexOf(mapLayer);
                this.element("href", "layer_" + mapLayerOrder + ".png");
            } else {
                this.element("href", KMLUtils.getMapUrl(KMLRasterTransformer.this.mapContext, mapLayer, false));
            }
        }
    }
}

