/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.georss;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.wms.util.WMSRequests;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.map.MapLayer;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureTemplate;
import org.vfny.geoserver.wms.responses.map.georss.GeoRSSTransformerBase;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class RSSGeoRSSTransformer
extends GeoRSSTransformerBase {
    FeatureTemplate template = new FeatureTemplate();

    public Translator createTranslator(ContentHandler handler) {
        return new RSSGeoRSSTranslator(handler);
    }

    class RSSGeoRSSTranslator
    extends GeoRSSTransformerBase.GeoRSSTranslatorSupport {
        public RSSGeoRSSTranslator(ContentHandler contentHandler) {
            super(contentHandler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            WMSMapContext map = (WMSMapContext)((Object)o);
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "version", "version", null, "2.0");
            this.start("rss", atts);
            this.start("channel");
            StringBuffer title = new StringBuffer();
            for (int i = 0; i < map.getLayerCount(); ++i) {
                MapLayer layer = map.getLayer(i);
                title.append(layer.getTitle()).append(",");
            }
            title.setLength(title.length() - 1);
            this.element("title", title.toString());
            this.start("link");
            this.cdata(WMSRequests.getGetMapUrl(map.getRequest(), null, null, null));
            this.end("link");
            try {
                this.encodeItems(map);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.end("channel");
            this.end("rss");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void encodeItems(WMSMapContext map) throws IOException {
            for (int i = 0; i < map.getLayerCount(); ++i) {
                MapLayer layer = map.getLayer(i);
                FeatureCollection features = null;
                try {
                    FeatureSource source = layer.getFeatureSource();
                    features = source.getFeatures();
                }
                catch (Exception e) {
                    String msg = "Unable to encode map layer: " + layer;
                    GeoRSSTransformerBase.LOGGER.log(Level.SEVERE, msg, e);
                }
                if (features == null) continue;
                FeatureIterator iterator = null;
                try {
                    iterator = features.features();
                    while (iterator.hasNext()) {
                        this.encodeItem(iterator.next(), map, layer);
                    }
                    continue;
                }
                finally {
                    if (iterator != null) {
                        features.close(iterator);
                    }
                }
            }
        }

        void encodeItem(Feature feature, WMSMapContext map, MapLayer layer) throws IOException {
            this.start("item");
            try {
                this.element("title", RSSGeoRSSTransformer.this.template.title(feature));
            }
            catch (Exception e) {
                String msg = "Error occured executing title template for: " + feature.getID();
                GeoRSSTransformerBase.LOGGER.log(Level.WARNING, msg, e);
            }
            String link = Requests.getBaseUrl((HttpServletRequest)map.getRequest().getHttpServletRequest(), (GeoServer)map.getRequest().getGeoServer());
            link = link + "wfs?request=getfeature&service=wfs&version=1.0.0&featureid=" + feature.getID();
            this.start("link");
            this.cdata(link);
            this.end("link");
            try {
                String description = RSSGeoRSSTransformer.this.template.description(feature);
                this.start("description");
                this.cdata(description);
                this.end("description");
            }
            catch (Exception e) {
                String msg = "Error occured executing description template for: " + feature.getID();
                GeoRSSTransformerBase.LOGGER.log(Level.WARNING, msg, e);
            }
            this.encodeGeometry(feature);
            this.end("item");
        }
    }
}

