/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;
import org.geotools.styling.Style;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.requests.WMSRequest;
import org.vfny.geoserver.wms.responses.palette.InverseColorMapOp;
import org.vfny.geoserver.wms.servlets.WMService;

public class GetMapRequest
extends WMSRequest {
    static final Color DEFAULT_BG = Color.white;
    public static final String SE_XML = "SE_XML";
    private static final String TRANSACTION_REQUEST_TYPE = "GetMap";
    private MandatoryParameters mandatoryParams = new MandatoryParameters();
    private OptionalParameters optionalParams = new OptionalParameters();

    public GetMapRequest(WMService service) {
        super(TRANSACTION_REQUEST_TYPE, service);
    }

    public Envelope getBbox() {
        return this.mandatoryParams.bbox;
    }

    public Color getBgColor() {
        return this.optionalParams.bgColor;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.optionalParams.crs;
    }

    public String getSRS() {
        return this.optionalParams.srs;
    }

    public String getExceptions() {
        return this.optionalParams.exceptions;
    }

    public String getFormat() {
        return this.mandatoryParams.format;
    }

    public int getHeight() {
        return this.mandatoryParams.height;
    }

    public MapLayerInfo[] getLayers() {
        return this.mandatoryParams.layers;
    }

    public List getStyles() {
        return this.mandatoryParams.styles;
    }

    public List getFilters() {
        return this.optionalParams.filters;
    }

    public boolean isTransparent() {
        return this.optionalParams.transparent;
    }

    public boolean isTiled() {
        return this.optionalParams.tiled;
    }

    public Point2D getTilesOrigin() {
        return this.optionalParams.tilesOrigin;
    }

    public int getBuffer() {
        return this.optionalParams.buffer;
    }

    public InverseColorMapOp getPaletteInverter() {
        return this.optionalParams.paletteInverter;
    }

    public int getWidth() {
        return this.mandatoryParams.width;
    }

    public int getKMScore() {
        return this.optionalParams.KMScore;
    }

    public boolean getKMattr() {
        return this.optionalParams.KMattr;
    }

    public boolean getSuperOverlay() {
        return this.optionalParams.superOverlay;
    }

    public boolean getLegend() {
        return this.optionalParams.legend;
    }

    public Integer getTime() {
        return this.optionalParams.time;
    }

    public Integer getElevation() {
        return this.optionalParams.elevation;
    }

    public void setBbox(Envelope bbox) {
        this.mandatoryParams.bbox = bbox;
    }

    public void setBgColor(Color bgColor) {
        this.optionalParams.bgColor = bgColor;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.optionalParams.crs = crs;
    }

    public void setSRS(String srs) {
        this.optionalParams.srs = srs;
    }

    public void setExceptions(String exceptions) {
        this.optionalParams.exceptions = exceptions;
    }

    public void setFormat(String format) {
        this.mandatoryParams.format = format;
    }

    public void setHeight(int height) {
        this.mandatoryParams.height = height;
    }

    public void setLayers(MapLayerInfo[] layers) {
        this.mandatoryParams.layers = layers;
    }

    public void setStyles(List styles) {
        this.mandatoryParams.styles = styles;
    }

    public void setFilters(List filters) {
        this.optionalParams.filters = filters;
    }

    public void setTransparent(boolean transparent) {
        this.optionalParams.transparent = transparent;
    }

    public void setBuffer(int buffer) {
        this.optionalParams.buffer = buffer;
    }

    public void setPaletteInverter(InverseColorMapOp paletteInverter) {
        this.optionalParams.paletteInverter = paletteInverter;
    }

    public void setTiled(boolean tiled) {
        this.optionalParams.tiled = tiled;
    }

    public void setTilesOrigin(Point2D origin) {
        this.optionalParams.tilesOrigin = origin;
    }

    public void setWidth(int width) {
        this.mandatoryParams.width = width;
    }

    public void setKMScore(int score) {
        this.optionalParams.KMScore = score;
    }

    public void setKMattr(boolean on) {
        this.optionalParams.KMattr = on;
    }

    public void setSuperOverlay(boolean superOverlay) {
        this.optionalParams.superOverlay = superOverlay;
    }

    public void setLegend(boolean legend) {
        this.optionalParams.legend = legend;
    }

    public void setTime(Integer time) {
        this.optionalParams.time = time;
    }

    public void setElevation(Integer elevation) {
        this.optionalParams.elevation = elevation;
    }

    private static final Color decodeColor(String hexColor) {
        return Color.decode(hexColor);
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("\nGetMap Request");
        returnString.append("\n version: " + this.version);
        returnString.append("\n output format: " + this.mandatoryParams.format);
        returnString.append("\n width height: " + this.mandatoryParams.height + "," + this.mandatoryParams.width);
        returnString.append("\n bbox: " + this.mandatoryParams.bbox);
        returnString.append("\n layers: ");
        for (int i = 0; i < this.mandatoryParams.layers.length; ++i) {
            returnString.append(this.mandatoryParams.layers[i].getName());
            if (i >= this.mandatoryParams.layers.length - 1) continue;
            returnString.append(",");
        }
        returnString.append("\n styles: ");
        Iterator it = this.mandatoryParams.styles.iterator();
        while (it.hasNext()) {
            Style s = (Style)it.next();
            returnString.append(s.getName());
            if (!it.hasNext()) continue;
            returnString.append(",");
        }
        return returnString.toString();
    }

    private class OptionalParameters {
        Color bgColor = DEFAULT_BG;
        CoordinateReferenceSystem crs;
        String srs;
        List filters;
        String exceptions = "SE_XML";
        boolean transparent = false;
        boolean tiled;
        public Point2D tilesOrigin;
        int buffer;
        InverseColorMapOp paletteInverter;
        int KMScore = 40;
        boolean KMattr = true;
        boolean superOverlay = false;
        boolean legend = false;
        Integer time;
        Integer elevation;

        private OptionalParameters() {
        }
    }

    private class MandatoryParameters {
        MapLayerInfo[] layers;
        List styles;
        Envelope bbox;
        int width;
        int height;
        String format;

        private MandatoryParameters() {
        }
    }
}

