/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.media.jai.util.Range;
import javax.xml.transform.TransformerException;
import org.geotools.data.DataSourceException;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.Filter;
import org.geotools.gml.producer.GeometryTransformer;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.kml.AbortedException;

public class KMLWriter
extends OutputStreamWriter {
    private static final Logger LOGGER = Logger.getLogger((class$org$vfny$geoserver$wms$responses$map$kml$KMLWriter == null ? (class$org$vfny$geoserver$wms$responses$map$kml$KMLWriter = KMLWriter.class$("org.vfny.geoserver.wms.responses.map.kml.KMLWriter")) : class$org$vfny$geoserver$wms$responses$map$kml$KMLWriter).getPackage().getName());
    private static DecimalFormat formatter;
    private SLDStyleFactory styleFactory = new SLDStyleFactory();
    private double scaleDenominator = 1.0;
    private GeometryTransformer transformer;
    private WMSMapContext mapContext;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$responses$map$kml$KMLWriter;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPolygon;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPoint;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiLineString;

    public KMLWriter(OutputStream out, WMSMapContext mapContext) {
        super(out);
        this.mapContext = mapContext;
        this.transformer = new GeometryTransformer();
        this.transformer.setUseDummyZ(true);
        this.transformer.setOmitXMLDeclaration(true);
        this.transformer.setNamespaceDeclarationEnabled(true);
    }

    public void setMaximunFractionDigits(int numDigits) {
        formatter.setMaximumFractionDigits(numDigits);
    }

    public int getMaximunFractionDigits() {
        return formatter.getMaximumFractionDigits();
    }

    public void setMinimunFractionDigits(int numDigits) {
        formatter.setMinimumFractionDigits(numDigits);
    }

    public int getMinimunFractionDigits() {
        return formatter.getMinimumFractionDigits();
    }

    public void write(double d) throws IOException {
        this.write(formatter.format(d));
    }

    public void newline() throws IOException {
        super.write(10);
    }

    public void writeFeatures(FeatureCollection features, Style style) throws IOException, AbortedException {
        try {
            FeatureType featureType = features.getSchema();
            Class gtype = featureType.getDefaultGeometry().getType();
            this.setUpWriterHandler(featureType);
            this.startFolder(null, null);
            FeatureTypeStyle[] fts = style.getFeatureTypeStyles();
            this.processStylers(features, fts);
            this.endFolder();
            LOGGER.fine("encoded " + featureType.getTypeName());
        }
        catch (NoSuchElementException ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
        catch (IllegalAttributeException ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void startFolder(String name, String description) throws IOException {
        this.write("<Folder>");
        if (name != null) {
            this.write("<Name>" + name + "</Name>");
        }
        if (description != null) {
            this.write("<Description>" + description + "</Description>");
        }
    }

    private void endFolder() throws IOException {
        this.write("</Folder>");
    }

    private void setUpWriterHandler(FeatureType featureType) throws IOException {
        String typeName = featureType.getTypeName();
        ArrayList atts = new ArrayList(0);
    }

    protected void writeGeometry(Geometry geom, GeometryTransformer trans) throws IOException, TransformerException {
        Class<?> geomClass = geom.getClass();
        if (this.isMultiPart(geom)) {
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                this.writeGeometry(geom.getGeometryN(i), trans);
            }
        } else {
            StringWriter tempWriter = new StringWriter();
            trans.transform((Object)geom, (Writer)tempWriter);
            String tempBuffer = tempWriter.toString();
            this.write(tempBuffer.replaceAll("gml:", ""));
        }
    }

    protected boolean isMultiPart(Geometry geom) {
        Class<?> geomClass = geom.getClass();
        return geomClass.equals(class$com$vividsolutions$jts$geom$MultiPolygon == null ? (class$com$vividsolutions$jts$geom$MultiPolygon = KMLWriter.class$("com.vividsolutions.jts.geom.MultiPolygon")) : class$com$vividsolutions$jts$geom$MultiPolygon) || geomClass.equals(class$com$vividsolutions$jts$geom$MultiPoint == null ? (class$com$vividsolutions$jts$geom$MultiPoint = KMLWriter.class$("com.vividsolutions.jts.geom.MultiPoint")) : class$com$vividsolutions$jts$geom$MultiPoint) || geomClass.equals(class$com$vividsolutions$jts$geom$MultiLineString == null ? (class$com$vividsolutions$jts$geom$MultiLineString = KMLWriter.class$("com.vividsolutions.jts.geom.MultiLineString")) : class$com$vividsolutions$jts$geom$MultiLineString);
    }

    private void processStylers(FeatureCollection features, FeatureTypeStyle[] featureStylers) throws IOException, IllegalAttributeException {
        for (int i = 0; i < featureStylers.length; ++i) {
            FeatureTypeStyle fts = featureStylers[i];
            String typeName = features.getSchema().getTypeName();
            if (typeName == null || !features.getSchema().isDescendedFrom(null, fts.getFeatureTypeName()) && !typeName.equalsIgnoreCase(fts.getFeatureTypeName())) continue;
            Rule[] rules = fts.getRules();
            ArrayList<Rule> ruleList = new ArrayList<Rule>();
            ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
            for (int j = 0; j < rules.length; ++j) {
                Rule r = rules[j];
                if (!this.isWithinScale(r)) continue;
                if (r.hasElseFilter()) {
                    elseRuleList.add(r);
                    continue;
                }
                ruleList.add(r);
            }
            if (ruleList.size() == 0 && elseRuleList.size() == 0) {
                return;
            }
            NumberRange scaleRange = new NumberRange(this.scaleDenominator, this.scaleDenominator);
            FeatureIterator reader = features.features();
            while (true) {
                try {
                    while (reader.hasNext()) {
                        Rule r;
                        boolean doElse = true;
                        Feature feature = reader.next();
                        Iterator it = ruleList.iterator();
                        while (it.hasNext()) {
                            r = (Rule)it.next();
                            LOGGER.finer("applying rule: " + r.toString());
                            Filter filter = r.getFilter();
                            if (filter != null && !filter.contains(feature)) continue;
                            doElse = false;
                            LOGGER.finer("processing Symobolizer ...");
                            Symbolizer[] symbolizers = r.getSymbolizers();
                            this.processSymbolizers(feature, symbolizers, (Range)scaleRange);
                        }
                        if (!doElse) continue;
                        LOGGER.finer("rules with an else filter");
                        it = elseRuleList.iterator();
                        while (it.hasNext()) {
                            r = (Rule)it.next();
                            Symbolizer[] symbolizers = r.getSymbolizers();
                            LOGGER.finer("processing Symobolizer ...");
                            this.processSymbolizers(feature, symbolizers, (Range)scaleRange);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warning("KML transform for feature failed " + e.getMessage());
                    continue;
                }
                break;
            }
            features.close(reader);
        }
    }

    private void processSymbolizers(Feature feature, Symbolizer[] symbolizers, Range scaleRange) throws IOException, TransformerException {
        String title = null;
        for (int m = 0; m < symbolizers.length; ++m) {
            LOGGER.finer("applying symbolizer " + symbolizers[m]);
            if (symbolizers[m] instanceof RasterSymbolizer) continue;
            Geometry g = this.findGeometry(feature, symbolizers[m]);
            if (symbolizers[m] instanceof TextSymbolizer) {
                title = (String)((TextSymbolizer)symbolizers[m]).getLabel().getValue(feature);
                continue;
            }
            Style2D style = this.styleFactory.createStyle(feature, symbolizers[m], scaleRange);
            this.write("<Placemark>");
            if (title != null) {
                this.write("<Name>" + title + "</Name>");
            }
            this.writeStyle(style);
            this.write("<GeometryCollection>");
            this.writeGeometry(g, this.transformer);
            this.write("</GeometryCollection>");
            this.write("</Placemark>");
            this.newline();
        }
    }

    private void writeStyle(Style2D style) throws IOException {
        if (style instanceof PolygonStyle2D) {
            this.write("<Style>");
            this.write("<geomColor>");
            Paint p = ((PolygonStyle2D)style).getFill();
            if (p instanceof Color) {
                this.write("aa" + this.colorToHex((Color)p));
            } else {
                this.write("ffaaaaaa");
            }
            this.write("</geomColor>");
            this.write("</Style>");
        }
    }

    private boolean isWithinScale(Rule r) {
        return true;
    }

    private Geometry findGeometry(Feature f, Symbolizer s) {
        String geomName = this.getGeometryPropertyName(s);
        Geometry geom = geomName == null ? f.getDefaultGeometry() : (Geometry)f.getAttribute(geomName);
        if (s instanceof PointSymbolizer) {
            geom = this.getCentroid(geom);
        }
        return geom;
    }

    public Geometry getCentroid(Geometry g) {
        if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            Coordinate[] pts = new Coordinate[gc.getNumGeometries()];
            for (int t = 0; t < gc.getNumGeometries(); ++t) {
                pts[t] = gc.getGeometryN(t).getCentroid().getCoordinate();
            }
            return g.getFactory().createMultiPoint(pts);
        }
        return g.getCentroid();
    }

    private CoordinateReferenceSystem findGeometryCS(Feature f, Symbolizer s) {
        String geomName = this.getGeometryPropertyName(s);
        if (geomName != null) {
            return ((GeometryAttributeType)f.getFeatureType().getAttributeType(geomName)).getCoordinateSystem();
        }
        return f.getFeatureType().getDefaultGeometry().getCoordinateSystem();
    }

    private String getGeometryPropertyName(Symbolizer s) {
        String geomName = null;
        if (s instanceof PolygonSymbolizer) {
            geomName = ((PolygonSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof PointSymbolizer) {
            geomName = ((PointSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof LineSymbolizer) {
            geomName = ((LineSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof TextSymbolizer) {
            geomName = ((TextSymbolizer)s).getGeometryPropertyName();
        }
        return geomName;
    }

    private String intToHex(int i) {
        String prelim = Integer.toHexString(i);
        if (prelim.length() < 2) {
            prelim = "0" + prelim;
        }
        return prelim;
    }

    private String colorToHex(Color c) {
        return this.intToHex(c.getBlue()) + this.intToHex(c.getGreen()) + this.intToHex(c.getRed());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Locale locale = new Locale("en", "US");
        DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols(locale);
        decimalSymbols.setDecimalSeparator('.');
        formatter = new DecimalFormat();
        formatter.setDecimalFormatSymbols(decimalSymbols);
        formatter.setGroupingSize(0);
        formatter.setDecimalSeparatorAlwaysShown(false);
        formatter.setDecimalFormatSymbols(null);
        formatter.setMaximumFractionDigits(5);
        formatter.setMinimumFractionDigits(0);
    }
}

