/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.map.kml.EncodeKML;

class KMLMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.kml");
    private EncodeKML kmlEncoder;
    private File temp;

    KMLMapProducer() {
    }

    public void abort(Service gs) {
        this.kmlEncoder.abort();
    }

    public String getContentType() {
        return "application/vnd.google-earth.kml+xml";
    }

    public void abort() {
        LOGGER.fine("aborting KML map response");
        if (this.kmlEncoder != null) {
            LOGGER.info("aborting KML encoder");
            this.kmlEncoder.abort();
        }
    }

    public void produceMap(WMSMapContext map) throws WmsException {
        try {
            this.temp = File.createTempFile("kml", null);
            this.kmlEncoder = new EncodeKML(map);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.temp));
            this.kmlEncoder.encode(bos);
            bos.flush();
            bos.close();
        }
        catch (IOException ioe) {
            WmsException we = new WmsException(ioe.getMessage());
            ((Throwable)((Object)we)).initCause(ioe);
            throw we;
        }
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        FileInputStream fis = new FileInputStream(this.temp);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            out.write(buf, 0, i);
        }
        fis.close();
    }
}

