/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.map.MapLayer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.kml.AbortedException;
import org.vfny.geoserver.wms.responses.map.kml.KMLWriter;

public class EncodeKML {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map.kml");
    private static final String KML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\t<kml xmlns=\"http://earth.google.com/kml/2.0\">\n";
    private static final String KML_FOOTER = "</kml>\n";
    private WMSMapContext mapContext;
    private KMLWriter writer;
    private boolean abortProcess;

    public EncodeKML(WMSMapContext mapContext) {
        this.mapContext = mapContext;
    }

    public void abort() {
        this.abortProcess = true;
    }

    public void encode(OutputStream out) throws IOException {
        Envelope env = this.mapContext.getAreaOfInterest();
        this.writer = new KMLWriter(out, this.mapContext);
        this.abortProcess = false;
        long t = System.currentTimeMillis();
        try {
            this.writeHeader();
            this.writeLayers();
            this.writeFooter();
            this.writer.flush();
            t = System.currentTimeMillis() - t;
            LOGGER.fine("KML generated, it took" + t + " ms");
        }
        catch (IOException ioe) {
            if (this.abortProcess) {
                LOGGER.fine("KML encoding aborted");
                return;
            }
            throw ioe;
        }
        catch (AbortedException ex) {
            return;
        }
    }

    private void writeHeader() throws IOException {
        this.writer.write(KML_HEADER);
    }

    private void writeFooter() throws IOException {
        this.writer.write(KML_FOOTER);
    }

    private void writeLayers() throws IOException, AbortedException {
        MapLayer[] layers = this.mapContext.getLayers();
        int nLayers = layers.length;
        int defMaxDecimals = this.writer.getMaximunFractionDigits();
        FilterFactory fFac = FilterFactoryFinder.createFilterFactory();
        for (int i = 0; i < nLayers; ++i) {
            MapLayer layer = layers[i];
            FeatureReader featureReader = null;
            FeatureSource fSource = layer.getFeatureSource();
            FeatureType schema = fSource.getSchema();
            try {
                BBoxExpression bboxExpression = fFac.createBBoxExpression(this.mapContext.getAreaOfInterest());
                GeometryFilter bboxFilter = fFac.createGeometryFilter((short)7);
                bboxFilter.addLeftGeometry((Expression)bboxExpression);
                bboxFilter.addRightGeometry((Expression)fFac.createAttributeExpression(schema, schema.getDefaultGeometry().getName()));
                DefaultQuery bboxQuery = new DefaultQuery(schema.getTypeName(), (Filter)bboxFilter);
                featureReader = fSource.getFeatures((Query)bboxQuery).reader();
                FeatureCollection fc = fSource.getFeatures((Query)bboxQuery);
                this.writer.writeFeatures(fc, layer.getStyle());
                LOGGER.fine("finished writing");
                continue;
            }
            catch (IOException ex) {
                LOGGER.info("process failed: " + ex.getMessage());
                throw ex;
            }
            catch (AbortedException ae) {
                LOGGER.info("process aborted: " + ae.getMessage());
                throw ae;
            }
            catch (Throwable t) {
                LOGGER.warning("UNCAUGHT exception: " + t.getMessage());
                IOException ioe = new IOException("UNCAUGHT exception: " + t.getMessage());
                ioe.setStackTrace(t.getStackTrace());
                throw ioe;
            }
            finally {
                if (featureReader != null) {
                    try {
                        featureReader.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }
}

