/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.responses.map.SVGBatikMapProducer;
import org.vfny.geoserver.wms.responses.map.SVGMapProducer;

public class SvgMapProducerFactory
implements GetMapProducerFactorySpi {
    private static final String PRODUCE_TYPE = "image/svg";
    static final String MIME_TYPE = "image/svg+xml";
    private static final Set SUPPORTED_FORMATS = Collections.singleton("image/svg+xml");

    public String getName() {
        return "Scalable Vector Graphics (SVG) map producer";
    }

    public Set getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean canProduce(String mapFormat) {
        return mapFormat != null && mapFormat.startsWith(PRODUCE_TYPE);
    }

    public GetMapProducer createMapProducer(String mapFormat, WMS wms) throws IllegalArgumentException {
        if (wms != null) {
            if ("Simple".equals(wms.getSvgRenderer())) {
                return new SVGMapProducer();
            }
            if ("Batik".equals(wms.getSvgRenderer())) {
                return new SVGBatikMapProducer(wms);
            }
        }
        return new SVGMapProducer();
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

