/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.responses.map.PNGMapProducer;

public class PNGMapProducerFactory
implements GetMapProducerFactorySpi {
    static final String MIME_TYPE = "image/png";
    private static final Set SUPPORTED_FORMATS = Collections.singleton("image/png");

    public String getName() {
        return "Portable Network Graphics (PNG) map producer";
    }

    public Set getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean canProduce(String mapFormat) {
        return MIME_TYPE.equals(mapFormat);
    }

    public GetMapProducer createMapProducer(String mapFormat, WMS wms) throws IllegalArgumentException {
        if (!this.canProduce(mapFormat)) {
            throw new IllegalArgumentException(mapFormat + " not supported by this map producer");
        }
        return new PNGMapProducer(MIME_TYPE);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

