/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.feature.FeatureType;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;

public abstract class GetFeatureInfoDelegate
implements Response {
    private GetFeatureInfoRequest request;

    public void execute(Request request) throws ServiceException {
        this.execute((GetFeatureInfoRequest)request);
    }

    protected void execute(GetFeatureInfoRequest request) throws WmsException {
        this.request = request;
        FeatureTypeInfo[] layers = request.getQueryLayers();
        Query[] queries = this.buildQueries(layers);
        int x = request.getXPixel();
        int y = request.getYPixel();
        this.execute(layers, queries, x, y);
    }

    public void abort(Service gs) {
    }

    protected abstract void execute(FeatureTypeInfo[] var1, Query[] var2, int var3, int var4) throws WmsException;

    private Query[] buildQueries(FeatureTypeInfo[] layers) throws WmsException {
        int nLayers = layers.length;
        Query[] queries = new Query[nLayers];
        GetFeatureInfoRequest infoRequest = this.getRequest();
        Envelope requestExtent = infoRequest.getGetMapRequest().getBbox();
        FilterFactory ffactory = FilterFactoryFinder.createFilterFactory();
        try {
            for (int i = 0; i < nLayers; ++i) {
                FeatureType schema = layers[i].getFeatureType();
                Filter finalLayerFilter = this.buildFilter(requestExtent, ffactory, schema);
                String[] props = this.guessProperties(layers[i], finalLayerFilter);
                DefaultQuery layerQuery = new DefaultQuery(schema.getTypeName(), finalLayerFilter, props);
                queries[i] = layerQuery;
            }
        }
        catch (IllegalFilterException ex) {
            throw new WmsException(ex, "Can't build layer queries: " + ex.getMessage(), this.getClass().getName() + "::parseFilters");
        }
        catch (IOException e) {
            throw new WmsException(e);
        }
        return queries;
    }

    private Filter buildFilter(Envelope requestExtent, FilterFactory ffactory, FeatureType schema) throws IllegalFilterException {
        GeometryFilter bboxFilter = ffactory.createGeometryFilter((short)7);
        BBoxExpression bboxExpr = ffactory.createBBoxExpression(requestExtent);
        AttributeExpression geomAttExpr = ffactory.createAttributeExpression(schema, schema.getDefaultGeometry().getName());
        bboxFilter.addLeftGeometry((Expression)geomAttExpr);
        bboxFilter.addRightGeometry((Expression)bboxExpr);
        return bboxFilter;
    }

    private String[] guessProperties(FeatureTypeInfo layer, Filter filter) throws IOException {
        ArrayList<String> atts = new ArrayList<String>();
        FeatureType type = layer.getFeatureType();
        String geom_name = type.getDefaultGeometry().getName();
        if (!atts.contains(geom_name)) {
            atts.add(geom_name);
        }
        String[] properties = atts.toArray(new String[atts.size()]);
        return properties;
    }

    protected GetFeatureInfoRequest getRequest() {
        return this.request;
    }

    public boolean canProduce(String mapFormat) {
        return this.getSupportedFormats().contains(mapFormat);
    }

    public abstract List getSupportedFormats();

    public abstract /* synthetic */ void writeTo(OutputStream var1) throws ServiceException, IOException;

    public abstract /* synthetic */ String getContentEncoding();

    public abstract /* synthetic */ String getContentType(GeoServer var1) throws IllegalStateException;
}

