/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.featureInfo.GetFeatureInfoDelegate;

public abstract class AbstractFeatureInfoResponse
extends GetFeatureInfoDelegate {
    protected static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.featureinfo");
    protected List supportedFormats = null;
    protected List results;
    protected List metas;
    protected String format = null;

    public String getContentEncoding() {
        return null;
    }

    public abstract void writeTo(OutputStream var1) throws ServiceException, IOException;

    public List getSupportedFormats() {
        return this.supportedFormats;
    }

    public void abort(GeoServer gs) {
    }

    public String getContentType(GeoServer gs) {
        if (this.format == null) {
            throw new IllegalStateException("Content type unknown since execute() has not been called yet");
        }
        return this.format;
    }

    protected void execute(FeatureTypeInfo[] requestedLayers, Query[] queries, int x, int y) throws WmsException {
        Coordinate[] coords;
        GetFeatureInfoRequest request = this.getRequest();
        this.format = request.getInfoFormat();
        GetMapRequest getMapReq = request.getGetMapRequest();
        int width = getMapReq.getWidth();
        int height = getMapReq.getHeight();
        Envelope bbox = getMapReq.getBbox();
        Coordinate upperLeft = this.pixelToWorld(x - 2, y - 2, bbox, width, height);
        Coordinate lowerRight = this.pixelToWorld(x + 2, y + 2, bbox, width, height);
        coords = new Coordinate[]{upperLeft, new Coordinate(lowerRight.x, upperLeft.y), lowerRight, new Coordinate(upperLeft.x, lowerRight.y), coords[0]};
        GeometryFactory geomFac = new GeometryFactory();
        LinearRing boundary = geomFac.createLinearRing(coords);
        Polygon pixelRect = geomFac.createPolygon(boundary, null);
        FilterFactory filterFac = FilterFactoryFinder.createFilterFactory();
        GeometryFilter getFInfoFilter = null;
        try {
            getFInfoFilter = filterFac.createGeometryFilter((short)7);
            getFInfoFilter.addLeftGeometry((Expression)filterFac.createLiteralExpression((Object)pixelRect));
        }
        catch (IllegalFilterException e) {
            e.printStackTrace();
            throw new WmsException(null, "Internal error : " + e.getMessage());
        }
        int layerCount = requestedLayers.length;
        this.results = new ArrayList(layerCount);
        this.metas = new ArrayList(layerCount);
        try {
            for (int i = 0; i < layerCount; ++i) {
                FeatureTypeInfo finfo = requestedLayers[i];
                DefaultQuery q = new DefaultQuery(finfo.getTypeName(), null, (Filter)getFInfoFilter, request.getFeatureCount(), Query.ALL_NAMES, null);
                FeatureCollection match = finfo.getFeatureSource().getFeatures((Query)q);
                this.results.add(match);
                this.metas.add(finfo);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new WmsException(null, "Internal error : " + ioe.getMessage());
        }
    }

    private Coordinate pixelToWorld(int x, int y, Envelope map, int width, int height) {
        AffineTransform at = this.worldToScreenTransform(map, width, height);
        Point2D result = null;
        try {
            result = at.inverseTransform(new Point2D.Double(x, y), new Point2D.Double());
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        Coordinate c = new Coordinate(result.getX(), result.getY());
        return c;
    }

    private AffineTransform worldToScreenTransform(Envelope mapExtent, int width, int height) {
        double scaleX = (double)width / mapExtent.getWidth();
        double scaleY = (double)height / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + (double)height;
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        return at;
    }
}

