/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.vfny.geoserver.wms.GetLegendGraphicProducer;
import org.vfny.geoserver.wms.GetLegendGraphicProducerSpi;
import org.vfny.geoserver.wms.responses.PNGLegendGraphicProducer;

public class PNGLegendGraphicProducerFactory
implements GetLegendGraphicProducerSpi {
    public String getName() {
        return "Legend graphic producer factory for PNG format";
    }

    public Set getSupportedFormats() {
        TreeSet<String> s = new TreeSet<String>();
        s.add("image/png");
        return s;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean canProduce(String mimeType) {
        return mimeType.equalsIgnoreCase("image/png");
    }

    public GetLegendGraphicProducer createLegendProducer(String format) throws IllegalArgumentException {
        if (!this.canProduce(format)) {
            throw new IllegalArgumentException(format + " not supported by this legend producer");
        }
        return new PNGLegendGraphicProducer();
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

