/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.map.MapContext;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;

public abstract class DefaultRasterMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map");
    private static final String DEFAULT_MAP_FORMAT = "image/png";
    private BufferedImage image;
    private GTRenderer renderer;
    private String format = null;
    private boolean abortRequested;
    private WMSMapContext mapContext;

    public DefaultRasterMapProducer() {
        this(DEFAULT_MAP_FORMAT);
    }

    public DefaultRasterMapProducer(String outputFormat) {
        this.setOutputFormat(outputFormat);
    }

    public void setOutputFormat(String format) {
        this.format = format;
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        this.formatImageOutputStream(this.format, this.image, out);
    }

    public void abort() {
        this.abortRequested = true;
        if (this.renderer != null) {
            this.renderer.stopRendering();
        }
    }

    public String getContentType() throws IllegalStateException {
        if (this.format == null) {
            throw new IllegalStateException("the output map format was not yet specified");
        }
        return this.format;
    }

    public String getContentEncoding() {
        return null;
    }

    public void produceMap(WMSMapContext map) throws WmsException {
        this.mapContext = map;
        int width = map.getMapWidth();
        int height = map.getMapHeight();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up " + width + "x" + height + " image");
        }
        BufferedImage curImage = new BufferedImage(width, height, 6);
        Graphics2D graphic = curImage.createGraphics();
        if (!map.isTransparent()) {
            graphic.setColor(map.getBgColor());
            graphic.fillRect(0, 0, width, height);
        } else {
            LOGGER.fine("setting to transparent");
            int type = 2;
            graphic.setComposite(AlphaComposite.getInstance(type));
            Color c = new Color(map.getBgColor().getRed(), map.getBgColor().getGreen(), map.getBgColor().getBlue(), 0);
            graphic.setBackground(map.getBgColor());
            graphic.setColor(c);
            graphic.fillRect(0, 0, width, height);
            type = 3;
            graphic.setComposite(AlphaComposite.getInstance(type));
        }
        Rectangle paintArea = new Rectangle(width, height);
        this.renderer = new StreamingRenderer();
        this.renderer.setContext((MapContext)map);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderer.setJava2DHints(hints);
        HashMap<String, Boolean> rendererParams = new HashMap<String, Boolean>();
        rendererParams.put("optimizedDataLoadingEnabled", new Boolean(true));
        this.renderer.setRendererHints(rendererParams);
        Envelope dataArea = map.getAreaOfInterest();
        AffineTransform at = RendererUtilities.worldToScreenTransform((Envelope)dataArea, (Rectangle)paintArea);
        if (this.abortRequested) {
            return;
        }
        this.renderer.paint(graphic, paintArea, at);
        map = null;
        if (!this.abortRequested) {
            this.image = curImage;
        }
        graphic.dispose();
    }

    protected abstract void formatImageOutputStream(String var1, BufferedImage var2, OutputStream var3) throws WmsException, IOException;

    public BufferedImage getImage() {
        return this.image;
    }

    protected WMSMapContext getMapContext() {
        return this.mapContext;
    }
}

