/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.media.jai.util.Range;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.renderer.lite.LiteShape2;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.wms.GetLegendGraphicProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;

public abstract class DefaultRasterLegendProducer
implements GetLegendGraphicProducer {
    private static final Logger LOGGER = Logger.getLogger((class$org$vfny$geoserver$wms$responses$DefaultRasterLegendProducer == null ? (class$org$vfny$geoserver$wms$responses$DefaultRasterLegendProducer = DefaultRasterLegendProducer.class$("org.vfny.geoserver.wms.responses.DefaultRasterLegendProducer")) : class$org$vfny$geoserver$wms$responses$DefaultRasterLegendProducer).getPackage().getName());
    private static final SLDStyleFactory styleFactory = new SLDStyleFactory();
    private static final double TOLERANCE = 1.0E-6;
    private static final StyledShapePainter shapePainter = new StyledShapePainter(null);
    private static final GeometryFactory geomFac = new GeometryFactory();
    public static final Color BG_COLOR = Color.WHITE;
    private static final ImageObserver imgObs = new Canvas();
    private static final float hpaddingFactor = 0.15f;
    private static final float vpaddingFactor = 0.15f;
    private BufferedImage legendGraphic;
    private boolean renderingStopRequested;
    private LiteShape2 sampleRect;
    private LiteShape2 sampleLine;
    private LiteShape2 samplePoint;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$responses$DefaultRasterLegendProducer;

    public void produceLegendGraphic(GetLegendGraphicRequest request) throws WmsException {
        Feature sampleFeature = this.createSampleFeature(request.getLayer());
        Style gt2Style = request.getStyle();
        FeatureTypeStyle[] ftStyles = gt2Style.getFeatureTypeStyles();
        double scaleDenominator = request.getScale();
        Rule[] applicableRules = request.getRule() != null ? new Rule[]{request.getRule()} : this.getApplicableRules(ftStyles, scaleDenominator);
        NumberRange scaleRange = new NumberRange(scaleDenominator, scaleDenominator);
        int ruleCount = applicableRules.length;
        ArrayList<BufferedImage> legendsStack = new ArrayList<BufferedImage>(ruleCount);
        int w = request.getWidth();
        int h = request.getHeight();
        for (int i = 0; i < ruleCount; ++i) {
            Symbolizer[] symbolizers = applicableRules[i].getSymbolizers();
            BufferedImage image = new BufferedImage(w, h, 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setColor(BG_COLOR);
            graphics.fillRect(0, 0, w, h);
            for (int sIdx = 0; sIdx < symbolizers.length; ++sIdx) {
                Symbolizer symbolizer = symbolizers[sIdx];
                Style2D style2d = styleFactory.createStyle(sampleFeature, symbolizer, (Range)scaleRange);
                LiteShape2 shape = this.getSampleShape(symbolizer, w, h);
                shapePainter.paint(graphics, shape, style2d, scaleDenominator);
            }
            legendsStack.add(image);
        }
        this.legendGraphic = this.scaleImage(DefaultRasterLegendProducer.mergeLegends(legendsStack), request);
    }

    private BufferedImage scaleImage(BufferedImage image, GetLegendGraphicRequest request) {
        int w = request.getWidth();
        int h = request.getHeight();
        BufferedImage scaledImage = new BufferedImage(w, h, 2);
        Graphics2D graphics = scaledImage.createGraphics();
        graphics.setColor(BG_COLOR);
        graphics.fillRect(0, 0, w, h);
        AffineTransform xform = new AffineTransform();
        xform.setToScale((double)w / (double)image.getWidth(), (double)h / (double)image.getHeight());
        graphics.drawImage(image, xform, null);
        return scaledImage;
    }

    private static BufferedImage mergeLegends(List imageStack) {
        if (imageStack.size() == 0) {
            throw new IllegalArgumentException("No legend graphics passed");
        }
        BufferedImage finalLegend = null;
        if (imageStack.size() == 1) {
            finalLegend = (BufferedImage)imageStack.get(0);
        } else {
            Graphics finalGraphics = null;
            int imgCount = imageStack.size();
            int w = 0;
            int h = 0;
            for (int i = 0; i < imgCount; ++i) {
                BufferedImage img = (BufferedImage)imageStack.get(i);
                if (i == 0) {
                    w = img.getWidth();
                    h = img.getHeight();
                    finalLegend = new BufferedImage(w, imgCount * h, 2);
                    finalGraphics = finalLegend.createGraphics();
                }
                finalGraphics.drawImage(img, 0, h * i, imgObs);
            }
        }
        return finalLegend;
    }

    private LiteShape2 getSampleShape(Symbolizer symbolizer, int legendWidth, int legendHeight) {
        LiteShape2 sampleShape;
        float hpad = (float)legendWidth * 0.15f;
        float vpad = (float)legendHeight * 0.15f;
        if (symbolizer instanceof LineSymbolizer) {
            if (this.sampleLine == null) {
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)((float)legendHeight - vpad)), new Coordinate((double)((float)legendWidth - hpad), (double)vpad)};
                LineString geom = geomFac.createLineString(coords);
                try {
                    this.sampleLine = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleLine = null;
                }
            }
            sampleShape = this.sampleLine;
        } else if (symbolizer instanceof PolygonSymbolizer) {
            if (this.sampleRect == null) {
                float w = (float)legendWidth - 2.0f * hpad;
                float h = (float)legendHeight - 2.0f * vpad;
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)vpad), new Coordinate((double)hpad, (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)vpad), new Coordinate((double)hpad, (double)vpad)};
                LinearRing shell = geomFac.createLinearRing(coords);
                Polygon geom = geomFac.createPolygon(shell, null);
                try {
                    this.sampleRect = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleRect = null;
                }
            }
            sampleShape = this.sampleRect;
        } else if (symbolizer instanceof PointSymbolizer || symbolizer instanceof TextSymbolizer) {
            if (this.samplePoint == null) {
                Coordinate coord = new Coordinate((double)(legendWidth / 2), (double)(legendHeight / 2));
                try {
                    this.samplePoint = new LiteShape2((Geometry)geomFac.createPoint(coord), null, null, false);
                }
                catch (Exception e) {
                    this.samplePoint = null;
                }
            }
            sampleShape = this.samplePoint;
        } else {
            throw new IllegalArgumentException("Unknown symbolizer: " + symbolizer);
        }
        return sampleShape;
    }

    private Feature createSampleFeature(FeatureType schema) throws WmsException {
        Feature sampleFeature;
        try {
            AttributeType[] atts = schema.getAttributeTypes();
            Object[] attributes = new Object[atts.length];
            for (int i = 0; i < atts.length; ++i) {
                attributes[i] = atts[i].createDefaultValue();
            }
            sampleFeature = schema.create(attributes);
        }
        catch (IllegalAttributeException e) {
            e.printStackTrace();
            throw new WmsException(e);
        }
        return sampleFeature;
    }

    private Rule[] getApplicableRules(FeatureTypeStyle[] ftStyles, double scaleDenominator) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        for (int i = 0; i < ftStyles.length; ++i) {
            FeatureTypeStyle fts = ftStyles[i];
            Rule[] rules = fts.getRules();
            for (int j = 0; j < rules.length; ++j) {
                Rule r = rules[j];
                if (!this.isWithInScale(r, scaleDenominator)) continue;
                ruleList.add(r);
            }
        }
        return ruleList.toArray(new Rule[ruleList.size()]);
    }

    private boolean isWithInScale(Rule r, double scaleDenominator) {
        return scaleDenominator == -1.0 || r.getMinScaleDenominator() - 1.0E-6 <= scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > scaleDenominator;
    }

    public BufferedImage getLegendGraphic() {
        if (this.legendGraphic == null) {
            throw new IllegalStateException();
        }
        return this.legendGraphic;
    }

    public void abort() {
        this.renderingStopRequested = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ String getContentType() throws IllegalStateException;

    public abstract /* synthetic */ void writeTo(OutputStream var1) throws IOException, ServiceException;
}

