/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.referencing.CRS;
import org.geotools.styling.SLDParser;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.TemporaryFeatureTypeInfo;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.GETMAPValidator;
import org.vfny.geoserver.util.SLDValidator;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapKvpReader;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.servlets.WMService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class GetMapXmlReader
extends XmlRequestReader {
    private static final StyleFactory styleFactory = StyleFactoryFinder.createStyleFactory();

    public GetMapXmlReader(WMService service) {
        super((AbstractService)service);
    }

    public Request read(Reader reader, HttpServletRequest req) throws WmsException {
        GetMapRequest getMapRequest = new GetMapRequest((WMService)this.getServiceRef());
        getMapRequest.setHttpServletRequest(req);
        boolean validateSchema = this.wantToValidate(req);
        try {
            this.parseGetMapXML(reader, getMapRequest, validateSchema);
        }
        catch (UnknownHostException unh) {
            throw new WmsException("unknown host - " + unh.getLocalizedMessage() + " - if its in a !DOCTYPE, remove the !DOCTYPE tag.");
        }
        catch (SAXParseException se) {
            throw new WmsException("line " + se.getLineNumber() + " column " + se.getColumnNumber() + " -- " + se.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new WmsException(e);
        }
        return getMapRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseGetMapXML(Reader xml, GetMapRequest getMapRequest, boolean validateSchema) throws Exception {
        File temp = null;
        if (validateSchema) {
            int c;
            temp = File.createTempFile("getMapPost", "xml");
            temp.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(temp);
            BufferedOutputStream out = new BufferedOutputStream(fos);
            while (-1 != (c = xml.read())) {
                out.write(c);
            }
            xml.close();
            out.flush();
            out.close();
            xml = new BufferedReader(new FileReader(temp));
        }
        try {
            NamedNodeMap atts;
            Node wmsVersion;
            Element rootNode;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setExpandEntityReferences(false);
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource input = new InputSource(xml);
            Document dom = db.parse(input);
            SLDParser sldParser = new SLDParser(styleFactory);
            Element nodeGetMap = rootNode = dom.getDocumentElement();
            if (!this.nodeNameEqual(nodeGetMap, "getmap")) {
                if (this.nodeNameEqual(nodeGetMap, "StyledLayerDescriptor")) {
                    if (validateSchema) {
                        this.validateSchemaSLD(temp, getMapRequest);
                    }
                    this.handlePostGet(rootNode, sldParser, getMapRequest);
                    return;
                }
                throw new Exception("GetMap XML parser - start node isnt 'GetMap' or 'StyledLayerDescriptor' tag");
            }
            if (validateSchema) {
                this.validateSchemaGETMAP(temp, getMapRequest);
            }
            if ((wmsVersion = (atts = nodeGetMap.getAttributes()).getNamedItem("version")) == null) {
                throw new Exception("GetMap XML parser - couldnt find attribute 'version' in GetMap tag");
            }
            getMapRequest.setVersion(wmsVersion.getNodeValue());
            this.parseBBox(getMapRequest, nodeGetMap);
            StyledLayerDescriptor sld = sldParser.parseDescriptor(this.getNode(rootNode, "StyledLayerDescriptor"));
            this.processStyles(getMapRequest, sld);
            this.parseXMLOutput(nodeGetMap, getMapRequest);
            getMapRequest.setExceptions(this.getNodeValue(nodeGetMap, "Exceptions"));
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private void handlePostGet(Node rootNode, SLDParser sldParser, GetMapRequest getMapRequest) throws Exception {
        HttpServletRequest request = getMapRequest.getHttpServletRequest();
        String qString = request.getQueryString();
        XmlRequestReader.LOGGER.fine("reading request: " + qString);
        HashMap<String, String> requestParams = new HashMap<String, String>();
        Enumeration pnames = request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String paramName = (String)pnames.nextElement();
            String paramValue = request.getParameter(paramName);
            requestParams.put(paramName.toUpperCase(), paramValue);
        }
        GetMapKvpReader kvpReader = new GetMapKvpReader(requestParams, (WMService)this.getServiceRef());
        String version = kvpReader.getRequestVersion();
        getMapRequest.setVersion(version);
        kvpReader.parseMandatoryParameters(getMapRequest, false);
        kvpReader.parseOptionalParameters(getMapRequest);
        StyledLayerDescriptor sld = sldParser.parseDescriptor(rootNode);
        this.processStyles(getMapRequest, sld);
    }

    private void processStyles(GetMapRequest getMapRequest, StyledLayerDescriptor sld) throws Exception {
        StyledLayer[] styledLayers = sld.getStyledLayers();
        int slCount = styledLayers.length;
        if (slCount == 0) {
            throw new WmsException("SLD document contains no layers");
        }
        ArrayList layers = new ArrayList();
        ArrayList styles = new ArrayList();
        StyledLayer sl = null;
        for (int i = 0; i < slCount; ++i) {
            FeatureTypeInfo currLayer;
            sl = styledLayers[i];
            String layerName = sl.getName();
            if (null == layerName) {
                throw new WmsException("A UserLayer without layer name was passed");
            }
            if (sl instanceof UserLayer && ((UserLayer)sl).getInlineFeatureDatastore() != null) {
                UserLayer ul = (UserLayer)sl;
                currLayer = new TemporaryFeatureTypeInfo(ul.getInlineFeatureDatastore(), ul.getInlineFeatureType());
            } else {
                currLayer = GetMapKvpReader.findLayer(getMapRequest, layerName);
            }
            GetMapKvpReader.addStyles(getMapRequest, currLayer, styledLayers[i], layers, styles);
        }
        getMapRequest.setLayers(layers.toArray(new FeatureTypeInfo[layers.size()]));
        getMapRequest.setStyles(styles);
    }

    private void parseBBox(GetMapRequest getMapRequest, Node nodeGetMap) throws Exception {
        Node bboxNode = this.getNode(nodeGetMap, "BoundingBox");
        if (bboxNode == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'BoundingBox' in GetMap tag");
        }
        List coordList = ExpressionDOMParser.parseCoords((Node)bboxNode);
        if (coordList.size() != 2) {
            throw new Exception("GetMap XML parser - node 'BoundingBox' in GetMap tag should have 2 coordinates in it");
        }
        Envelope env = new Envelope();
        for (int i = 0; i < coordList.size(); ++i) {
            env.expandToInclude((Coordinate)coordList.get(i));
        }
        getMapRequest.setBbox(env);
        NamedNodeMap atts = bboxNode.getAttributes();
        Node srsNode = atts.getNamedItem("srsName");
        if (srsNode != null) {
            String srs = srsNode.getNodeValue();
            String epsgCode = srs.substring(srs.indexOf(35) + 1);
            epsgCode = "EPSG:" + epsgCode;
            try {
                CoordinateReferenceSystem mapcrs = CRS.decode((String)epsgCode);
                getMapRequest.setCrs(mapcrs);
            }
            catch (Exception e) {
                throw new WmsException(e.getLocalizedMessage(), "InvalidSRS");
            }
        }
    }

    private void parseXMLOutput(Node nodeGetMap, GetMapRequest getMapRequest) throws Exception {
        Node sizeNode;
        String bgColor;
        Node outputNode = this.getNode(nodeGetMap, "Output");
        if (outputNode == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Output' in GetMap tag");
        }
        String format = this.getNodeValue(outputNode, "Format");
        if (format == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Format' in GetMap/Output tag");
        }
        getMapRequest.setFormat(format);
        String trans = this.getNodeValue(outputNode, "Transparent");
        if (trans != null) {
            if (trans.equalsIgnoreCase("false") || trans.equalsIgnoreCase("0")) {
                getMapRequest.setTransparent(false);
            } else {
                getMapRequest.setTransparent(true);
            }
        }
        if ((bgColor = this.getNodeValue(outputNode, "BGcolor")) != null) {
            getMapRequest.setBgColor(Color.decode(bgColor));
        }
        if ((sizeNode = this.getNode(outputNode, "Size")) == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Size' in GetMap/Output tag");
        }
        String width = this.getNodeValue(sizeNode, "Width");
        if (width == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Width' in GetMap/Output/Size tag");
        }
        getMapRequest.setWidth(Integer.parseInt(width));
        String height = this.getNodeValue(sizeNode, "Height");
        if (width == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Height' in GetMap/Output/Size tag");
        }
        getMapRequest.setHeight(Integer.parseInt(height));
    }

    public Node getNode(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase(wantedChildName)) continue;
            return child;
        }
        return null;
    }

    public String getNodeValue(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase(wantedChildName)) continue;
            return child.getChildNodes().item(0).getNodeValue();
        }
        return null;
    }

    public boolean nodeNameEqual(Node n, String name) {
        if (n.getNodeName().equalsIgnoreCase(name)) {
            return true;
        }
        String nname = n.getNodeName();
        int idx = nname.indexOf(58);
        if (idx == -1) {
            return false;
        }
        return nname.substring(idx + 1).equalsIgnoreCase(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSchemaSLD(File f, GetMapRequest getMapRequest) throws Exception {
        SLDValidator validator = new SLDValidator();
        List errors = null;
        try {
            FileInputStream in = null;
            try {
                in = new FileInputStream(f);
                errors = validator.validateSLD((InputStream)in, getMapRequest.getHttpServletRequest().getSession().getServletContext());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            if (errors.size() != 0) {
                in = new FileInputStream(f);
                throw new WmsException(SLDValidator.getErrorMessage((InputStream)in, (List)errors));
            }
        }
        catch (IOException e) {
            String msg = "Creating remote SLD url: " + e.getMessage();
            XmlRequestReader.LOGGER.log(Level.WARNING, msg, e);
            throw new WmsException(e, msg, "parseSldParam");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSchemaGETMAP(File f, GetMapRequest getMapRequest) throws Exception {
        GETMAPValidator validator = new GETMAPValidator();
        List errors = null;
        try {
            FileInputStream in = null;
            try {
                in = new FileInputStream(f);
                errors = validator.validateGETMAP((InputStream)in, getMapRequest.getHttpServletRequest().getSession().getServletContext());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            if (errors.size() != 0) {
                in = new FileInputStream(f);
                throw new WmsException(GETMAPValidator.getErrorMessage((InputStream)in, (List)errors));
            }
        }
        catch (IOException e) {
            String msg = "Creating remote GETMAP url: " + e.getMessage();
            XmlRequestReader.LOGGER.log(Level.WARNING, msg, e);
            throw new WmsException(e, msg, "GETMAP validator");
        }
    }

    private boolean wantToValidate(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        return (queryString = queryString.toLowerCase()).startsWith("validateschema") || queryString.indexOf("&validateschema") != -1;
    }
}

