/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.requests.GetMapKvpReader;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;
import org.vfny.geoserver.wms.servlets.WMService;

public class GetFeatureInfoKvpReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.readers.wms");
    private GetFeatureInfoRequest request;
    private GetMapKvpReader getMapReader;

    public GetFeatureInfoKvpReader(Map kvpPairs, WMService service) {
        super(kvpPairs, service);
        this.getMapReader = new GetMapKvpReader(kvpPairs, service);
    }

    public Request getRequest(HttpServletRequest httpRequest) throws ServiceException {
        this.request = new GetFeatureInfoRequest((WMService)this.getServiceRef());
        this.request.setHttpServletRequest(httpRequest);
        String version = this.getRequestVersion();
        this.request.setVersion(version);
        this.getMapReader.setStylesRequired(false);
        GetMapRequest getMapPart = (GetMapRequest)this.getMapReader.getRequest(httpRequest);
        this.request.setGetMapRequest(getMapPart);
        FeatureTypeInfo[] layers = this.parseLayers();
        this.request.setQueryLayers(layers);
        String format = this.getValue("INFO_FORMAT");
        if (format == null) {
            format = "text/plain";
        }
        this.request.setInfoFormat(format);
        this.request.setFeatureCount(1);
        try {
            int maxFeatures = Integer.parseInt(this.getValue("FEATURE_COUNT"));
            this.request.setFeatureCount(maxFeatures);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            int x = Integer.parseInt(this.getValue("X"));
            int y = Integer.parseInt(this.getValue("Y"));
            this.request.setXPixel(x);
            this.request.setYPixel(y);
        }
        catch (NumberFormatException ex) {
            throw new WmsException("X and Y incorrectly specified");
        }
        String exceptionsFormat = this.getValue("EXCEPTIONS");
        this.request.setExeptionFormat(exceptionsFormat);
        return this.request;
    }

    private FeatureTypeInfo[] parseLayers() throws WmsException {
        List layers = KvpRequestReader.readFlat((String)this.getValue("QUERY_LAYERS"), (String)",");
        int layerCount = layers.size();
        if (layerCount == 0) {
            throw new WmsException("No QUERY_LAYERS has been requested", ((Object)((Object)this)).getClass().getName());
        }
        FeatureTypeInfo[] featureTypes = new FeatureTypeInfo[layerCount];
        Data catalog = null;
        catalog = this.request.getWMS().getData();
        String layerName = null;
        FeatureTypeInfo ftype = null;
        try {
            for (int i = 0; i < layerCount; ++i) {
                layerName = (String)layers.get(i);
                featureTypes[i] = ftype = catalog.getFeatureTypeInfo(layerName);
            }
        }
        catch (NoSuchElementException ex) {
            throw new WmsException(ex, layerName + ": no such layer on this server", ((Object)((Object)this)).getClass().getName());
        }
        return featureTypes;
    }
}

