/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;
import org.vfny.geoserver.wms.servlets.WMService;

public class DescribeLayerKvpRequestReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER = Logger.getLogger((class$org$vfny$geoserver$wms$requests$DescribeLayerKvpRequestReader == null ? (class$org$vfny$geoserver$wms$requests$DescribeLayerKvpRequestReader = DescribeLayerKvpRequestReader.class$("org.vfny.geoserver.wms.requests.DescribeLayerKvpRequestReader")) : class$org$vfny$geoserver$wms$requests$DescribeLayerKvpRequestReader).getPackage().getName());
    static /* synthetic */ Class class$org$vfny$geoserver$wms$requests$DescribeLayerKvpRequestReader;

    public DescribeLayerKvpRequestReader(Map params, WMService service) {
        super(params, service);
    }

    public Request getRequest(HttpServletRequest request) throws ServiceException {
        DescribeLayerRequest req = new DescribeLayerRequest((WMService)this.service);
        req.setHttpServletRequest(request);
        String layersParam = this.getValue("LAYERS");
        LOGGER.fine(layersParam);
        List layers = KvpRequestReader.readFlat((String)layersParam, (String)",");
        LOGGER.fine(layers.toString());
        int layerCount = layers.size();
        if (layerCount == 0) {
            throw new WmsException("No LAYERS has been requested", ((Object)((Object)this)).getClass().getName());
        }
        Data catalog = req.getWMS().getData();
        LOGGER.fine(catalog.toString());
        String layerName = null;
        FeatureTypeInfo ftype = null;
        try {
            LOGGER.fine("looking featuretypeinfos");
            for (int i = 0; i < layerCount; ++i) {
                layerName = (String)layers.get(i);
                LOGGER.fine("Looking for layer " + layerName);
                ftype = catalog.getFeatureTypeInfo(layerName);
                req.addLayer(ftype);
                LOGGER.fine(layerName + " found");
            }
        }
        catch (NoSuchElementException ex) {
            throw new WmsException(ex, layerName + ": no such layer on this server", "LayerNotDefined");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsed request " + (Object)((Object)req));
        }
        return req;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

