/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms;

import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.util.Requests;

public class WmsException
extends ServiceException {
    private static final String SE_XML = "application/vnd.ogc.se_xml";

    public WmsException() {
    }

    public WmsException(String message) {
        super(message);
    }

    public WmsException(Throwable e) {
        super(e.getMessage(), e);
    }

    public WmsException(String message, String code) {
        super(message);
        this.code = code;
    }

    public WmsException(Throwable e, String preMessage, String locator) {
        super(e, preMessage, locator);
    }

    public String getXmlResponse(boolean printStackTrace, HttpServletRequest request) {
        StringBuffer returnXml = new StringBuffer("<?xml version=\"1.0\"");
        returnXml.append(" encoding=\"UTF-8\" standalone=\"no\" ?>");
        String dtdUrl = Requests.getSchemaBaseUrl((HttpServletRequest)request) + "/wms/1.1.1/WMS_exception_1_1_1.dtd";
        returnXml.append("<!DOCTYPE ServiceExceptionReport SYSTEM \"" + dtdUrl + "\"> ");
        returnXml.append("<ServiceExceptionReport version=\"1.1.1\">");
        returnXml.append("    <ServiceException" + (this.code != null ? " code=\"" + this.code + "\"" : "") + ">" + this.getXmlMessage(printStackTrace) + "</ServiceException>");
        returnXml.append("  </ServiceExceptionReport>");
        return returnXml.toString();
    }

    public String getMimeType(GeoServer geoserver) {
        return SE_XML;
    }
}

