/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.util.logging.Logging;
import org.geotools.validation.FeatureValidation;
import org.geotools.validation.IntegrityValidation;
import org.geotools.validation.PlugIn;
import org.geotools.validation.Validation;
import org.geotools.validation.ValidationProcessor;
import org.geotools.validation.dto.ArgumentDTO;
import org.geotools.validation.dto.PlugInDTO;
import org.geotools.validation.dto.TestDTO;
import org.geotools.validation.dto.TestSuiteDTO;
import org.geotools.validation.xml.ValidationException;
import org.geotools.validation.xml.XMLReader;
import org.vfny.geoserver.global.Config;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class GeoValidator
extends ValidationProcessor {
    public static final String WEB_CONTAINER_KEY = "GeoValidator";
    private Map testSuites;
    private Map plugIns;
    private Map errors;
    static /* synthetic */ Class class$org$geotools$validation$Validation;

    public GeoValidator() {
    }

    public GeoValidator(Config config) {
        this.loadPlugins(config.dataDirectory());
    }

    protected void loadPlugins(File dataDir) {
        HashMap plugIns = null;
        Map testSuites = null;
        try {
            File plugInDir = GeoserverDataDirectory.findConfigDir((File)dataDir, (String)"plugIns");
            File validationDir = GeoserverDataDirectory.findConfigDir((File)dataDir, (String)"validation");
            if (plugInDir != null && plugInDir.exists()) {
                plugIns = XMLReader.loadPlugIns((File)plugInDir);
                if (validationDir != null && validationDir.exists()) {
                    testSuites = XMLReader.loadValidations((File)validationDir, plugIns);
                }
            }
        }
        catch (Exception e) {
            Logging.getLogger((String)"org.vfny.geoserver.global").log(Level.WARNING, "loading plugins", e);
        }
        if (testSuites == null) {
            testSuites = new HashMap();
        }
        if (plugIns == null) {
            plugIns = new HashMap();
        }
        this.load(testSuites, plugIns);
    }

    public GeoValidator(Map testSuites, Map plugIns) {
        this.load(testSuites, plugIns);
    }

    public Map getErrors() {
        return this.errors;
    }

    public void load(Map testSuites, Map plugIns) {
        PlugIn plugIn;
        TestSuiteDTO dto;
        this.plugIns = plugIns;
        this.testSuites = testSuites;
        this.errors = new HashMap();
        HashSet<String> plugInNames = new HashSet<String>();
        Iterator<Object> i = testSuites.keySet().iterator();
        while (i.hasNext()) {
            dto = (TestSuiteDTO)testSuites.get(i.next());
            Iterator j = dto.getTests().keySet().iterator();
            while (j.hasNext()) {
                TestDTO tdto = (TestDTO)dto.getTests().get(j.next());
                plugInNames.add(tdto.getPlugIn().getName());
            }
        }
        i = plugIns.values().iterator();
        while (i.hasNext()) {
            dto = (PlugInDTO)i.next();
            this.errors.put(dto, Boolean.FALSE);
        }
        HashMap<String, PlugIn> defaultPlugIns = new HashMap<String, PlugIn>(plugInNames.size());
        i = plugInNames.iterator();
        while (i.hasNext()) {
            HashMap plugInArgs;
            String plugInName = (String)i.next();
            PlugInDTO dto2 = (PlugInDTO)plugIns.get(plugInName);
            Class plugInClass = null;
            try {
                plugInClass = Class.forName(dto2.getClassName());
            }
            catch (ClassNotFoundException e) {
                this.errors.put(dto2, e);
                e.printStackTrace();
            }
            if (plugInClass == null) {
                Class clazz = plugInClass = class$org$geotools$validation$Validation == null ? GeoValidator.class$("org.geotools.validation.Validation") : class$org$geotools$validation$Validation;
            }
            if ((plugInArgs = dto2.getArgs()) == null) {
                plugInArgs = new HashMap();
            }
            try {
                plugIn = new PlugIn(plugInName, plugInClass, dto2.getDescription(), plugInArgs);
                defaultPlugIns.put(plugInName, plugIn);
            }
            catch (ValidationException e) {
                e.printStackTrace();
                this.errors.put(dto2, e);
                continue;
            }
            this.errors.put(dto2, Boolean.TRUE);
        }
        i = testSuites.keySet().iterator();
        while (i.hasNext()) {
            TestSuiteDTO tdto = (TestSuiteDTO)testSuites.get(i.next());
            Iterator j = tdto.getTests().keySet().iterator();
            while (j.hasNext()) {
                TestDTO dto3;
                block18: {
                    dto3 = (TestDTO)tdto.getTests().get(j.next());
                    HashMap testArgs = dto3.getArgs();
                    if (testArgs == null) {
                        testArgs = new HashMap();
                    } else {
                        HashMap<String, Object> m = new HashMap<String, Object>();
                        Iterator k = testArgs.keySet().iterator();
                        while (k.hasNext()) {
                            ArgumentDTO adto = (ArgumentDTO)testArgs.get(k.next());
                            m.put(adto.getName(), adto.getValue());
                        }
                        testArgs = m;
                    }
                    try {
                        plugIn = (PlugIn)defaultPlugIns.get(dto3.getPlugIn().getName());
                        Validation validation = plugIn.createValidation(dto3.getName(), dto3.getDescription(), testArgs);
                        if (validation instanceof FeatureValidation) {
                            this.addValidation((FeatureValidation)validation);
                        }
                        if (!(validation instanceof IntegrityValidation)) break block18;
                        this.addValidation((IntegrityValidation)validation);
                    }
                    catch (ValidationException e) {
                        e.printStackTrace();
                        this.errors.put(dto3, e);
                        continue;
                    }
                }
                this.errors.put(dto3, Boolean.TRUE);
            }
            this.errors.put(tdto, Boolean.TRUE);
        }
    }

    public Object toPlugInDTO() {
        return this.plugIns;
    }

    public Object toTestSuiteDTO() {
        return this.testSuites;
    }

    public Map getPlugIns() {
        return this.plugIns;
    }

    public Map getTestSuites() {
        return this.testSuites;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

