/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config.validation;

import java.beans.PropertyDescriptor;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.geotools.validation.dto.ArgumentDTO;
import org.geotools.validation.dto.PlugInDTO;
import org.geotools.validation.dto.TestDTO;
import org.geotools.validation.xml.ArgHelper;
import org.geotools.validation.xml.ValidationException;
import org.vfny.geoserver.config.validation.ArgumentConfig;
import org.vfny.geoserver.config.validation.PlugInConfig;

public class TestConfig {
    public static final String CURRENTLY_SELECTED_KEY = "selectedTest";
    private String name;
    private String description;
    private PlugInConfig plugIn;
    private PropertyDescriptor[] pds;
    private Map args;

    public TestConfig() {
        this.args = new HashMap();
    }

    public TestConfig(TestConfig t) {
        this.name = t.getName();
        this.description = t.getDescription();
        this.plugIn = new PlugInConfig(t.getPlugIn());
        this.args = new HashMap();
        if (t.getArgs() != null) {
            Iterator i = t.getArgs().keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                this.args.put(key, new ArgumentConfig((ArgumentConfig)t.getArgs().get(key)));
            }
        }
    }

    public TestConfig(TestDTO t, Map plugInConfigs) {
        this.name = t.getName();
        this.description = t.getDescription();
        this.plugIn = (PlugInConfig)plugInConfigs.get(t.getPlugIn().getName());
        this.args = new HashMap();
        if (t.getArgs() != null) {
            Iterator i = t.getArgs().keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                this.args.put(key, new ArgumentConfig((ArgumentDTO)t.getArgs().get(key)));
            }
        }
    }

    public Object clone() {
        return new TestConfig(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TestDTO)) {
            return false;
        }
        TestDTO t = (TestDTO)obj;
        boolean r = true;
        if (this.name != null) {
            boolean bl = r = r && this.name.equals(t.getName());
        }
        if (this.description != null) {
            boolean bl = r = r && this.description.equals(t.getDescription());
        }
        if (this.plugIn == null) {
            if (t.getPlugIn() != null) {
                return false;
            }
        } else if (t.getPlugIn() != null) {
            r = r && this.plugIn.equals(t.getPlugIn());
        } else {
            return false;
        }
        if (this.args == null) {
            if (t.getArgs() != null) {
                return false;
            }
        } else if (t.getArgs() != null) {
            r = r && ((Object)this.args).equals(t.getArgs());
        } else {
            return false;
        }
        return r;
    }

    public int hashCode() {
        int r = 1;
        if (this.name != null) {
            r *= this.name.hashCode();
        }
        if (this.description != null) {
            r *= this.description.hashCode();
        }
        if (this.plugIn != null) {
            r *= this.plugIn.hashCode();
        }
        if (this.args != null) {
            r *= ((Object)this.args).hashCode();
        }
        return r;
    }

    public TestDTO toDTO(Map plugIns) {
        TestDTO dto = new TestDTO();
        dto.setName(this.name);
        dto.setDescription(this.description);
        dto.setPlugIn((PlugInDTO)plugIns.get(this.plugIn.getName()));
        HashMap<String, ArgumentDTO> myArgs = new HashMap<String, ArgumentDTO>();
        if (this.args != null) {
            Iterator i = this.args.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                myArgs.put(key, ((ArgumentConfig)this.args.get(key)).toDTO());
            }
        }
        dto.setArgs(myArgs);
        return dto;
    }

    public Map getArgs() {
        return this.args;
    }

    public void setArgs(Map args) {
        Iterator i = args.keySet().iterator();
        while (i.hasNext()) {
            if (!((ArgumentConfig)args.get(i.next())).isFinal()) continue;
            throw new IllegalArgumentException("Cannot include final arguments as part of a test.");
        }
        this.args = args;
    }

    public String getArgStringValue(String name) {
        ArgumentConfig ac = (ArgumentConfig)this.args.get(name);
        if (ac == null) {
            return null;
        }
        return ArgHelper.getArgumentStringEncoding((Object)ac.getValue());
    }

    public Object getArgValue(String name) {
        ArgumentConfig ac = (ArgumentConfig)this.args.get(name);
        if (ac == null) {
            return null;
        }
        return ac.getValue();
    }

    public boolean setArgStringValue(String name, String value) {
        ArgumentConfig ac = (ArgumentConfig)this.args.get(name);
        if (value == null || value.equals("")) {
            this.args.remove(name);
            return true;
        }
        if (ac == null) {
            return this.addArgStringValue(name, value);
        }
        if (ac.isFinal()) {
            throw new IllegalArgumentException("Cannot include final arguments as part of a test.");
        }
        StringReader sr = new StringReader(value);
        try {
            ac.setValue(ArgHelper.getArgumentInstance((String)ArgHelper.getArgumentType((Object)ac.getValue()), (String)value));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean addArgStringValue(String name, String value) {
        PropertyDescriptor pd = this.getPropertyDescriptor(name);
        if (pd == null) {
            return false;
        }
        if (value == null || value.equals("")) {
            this.args.remove(name);
            return false;
        }
        Class<?> cl = pd.getPropertyType();
        ArgumentConfig ac = new ArgumentConfig();
        ac.setName(name);
        try {
            String argType = ArgHelper.getArgumentType(cl);
            ac.setValue(ArgHelper.getArgumentInstance((String)argType, (String)value));
        }
        catch (ValidationException e) {
            e.printStackTrace();
            return false;
        }
        this.args.put(name, ac);
        return true;
    }

    public Object createArg(String name, String value) throws Exception {
        PropertyDescriptor pd = this.getPropertyDescriptor(name);
        if (pd == null) {
            return null;
        }
        if (value == null || value.equals("")) {
            return null;
        }
        Class<?> cl = pd.getPropertyType();
        return ArgHelper.getArgumentInstance((String)ArgHelper.getArgumentType(cl), (String)value);
    }

    public boolean setArgValue(String name, Object value) {
        if (value == null || value.equals("")) {
            this.args.remove(name);
            return true;
        }
        ArgumentConfig ac = (ArgumentConfig)this.args.get(name);
        if (ac == null) {
            ac = new ArgumentConfig();
            ac.setName(name);
            this.args.put(name, ac);
        }
        if (ac.isFinal()) {
            throw new IllegalArgumentException("Cannot include final arguments as part of a test.");
        }
        ac.setValue(value);
        return true;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        if (this.pds == null) {
            PropertyDescriptor[] completeList = this.plugIn.getPropertyDescriptors();
            HashSet<PropertyDescriptor> these = new HashSet<PropertyDescriptor>();
            for (int i = 0; i < completeList.length; ++i) {
                PropertyDescriptor property = completeList[i];
                if (property.isHidden() || property.isExpert() || property.getWriteMethod() == null || "name".equals(property.getName()) || "description".equals(property.getName())) continue;
                these.add(property);
            }
            Object[] ob = these.toArray();
            this.pds = new PropertyDescriptor[ob.length];
            for (int i = 0; i < ob.length; ++i) {
                this.pds[i] = (PropertyDescriptor)ob[i];
            }
        }
        return this.pds;
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        if (name == null) {
            throw new NullPointerException("name must be defined to get a PropertyDescriptor.");
        }
        if (this.pds == null) {
            this.pds = this.getPropertyDescriptors();
        }
        for (int i = 0; i < this.pds.length; ++i) {
            if (!name.equals(this.pds[i].getName())) continue;
            return this.pds[i];
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PlugInConfig getPlugIn() {
        return this.plugIn;
    }

    public void setPlugIn(PlugInConfig plugIn) {
        this.plugIn = plugIn;
    }
}

