/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config.validation;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.validation.dto.ArgumentDTO;
import org.geotools.validation.dto.PlugInDTO;
import org.geotools.validation.xml.ArgHelper;
import org.geotools.validation.xml.ValidationException;
import org.vfny.geoserver.config.validation.ArgumentConfig;

public class PlugInConfig {
    public static final String CONFIG_KEY = "Validation.PlugIn";
    private String name;
    private String description;
    private String className;
    private Map args;

    public PlugInConfig() {
        this.args = new HashMap();
    }

    public PlugInConfig(PlugInConfig pi) {
        this.name = pi.getName();
        this.description = pi.getDescription();
        this.className = pi.getClassName();
        this.args = new HashMap();
        if (pi.getArgs() != null) {
            Iterator i = pi.getArgs().keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                this.args.put(key, new ArgumentConfig((ArgumentConfig)pi.getArgs().get(key)));
            }
        }
    }

    public PlugInConfig(PlugInDTO pi) {
        this.name = pi.getName();
        this.description = pi.getDescription();
        this.className = pi.getClassName();
        this.args = new HashMap();
        if (pi.getArgs() != null) {
            Iterator i = pi.getArgs().keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                this.args.put(key, new ArgumentConfig((ArgumentDTO)pi.getArgs().get(key)));
            }
        }
    }

    public Object clone() {
        return new PlugInConfig(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PlugInDTO)) {
            return false;
        }
        PlugInDTO pi = (PlugInDTO)obj;
        boolean r = true;
        if (this.name != null) {
            boolean bl = r = r && this.name.equals(pi.getName());
        }
        if (this.description != null) {
            boolean bl = r = r && this.description.equals(pi.getDescription());
        }
        if (this.className != null) {
            boolean bl = r = r && this.className.equals(pi.getClassName());
        }
        if (this.args == null) {
            if (pi.getArgs() != null) {
                return false;
            }
        } else if (pi.getArgs() != null) {
            r = r && ((Object)this.args).equals(pi.getArgs());
        } else {
            return false;
        }
        return r;
    }

    public int hashCode() {
        int i = 1;
        if (this.name != null) {
            i *= this.name.hashCode();
        }
        if (this.description != null) {
            i *= this.description.hashCode();
        }
        if (this.className != null) {
            i *= this.className.hashCode();
        }
        if (this.args != null) {
            i *= ((Object)this.args).hashCode();
        }
        return i;
    }

    public PlugInDTO toDTO() {
        PlugInDTO dto = new PlugInDTO();
        dto.setName(this.name);
        dto.setDescription(this.description);
        dto.setClassName(this.className);
        HashMap<String, ArgumentDTO> myArgs = new HashMap<String, ArgumentDTO>();
        if (this.args != null) {
            Iterator i = this.args.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                myArgs.put(key, ((ArgumentConfig)this.args.get(key)).toDTO());
            }
        }
        dto.setArgs(myArgs);
        return dto;
    }

    public Map getArgs() {
        return this.args;
    }

    public void setArgs(Map args) {
        this.args = args;
    }

    public String getArgStringValue(String name) {
        ArgumentConfig ac = (ArgumentConfig)this.args.get(name);
        if (ac == null) {
            return null;
        }
        return ArgHelper.getArgumentStringEncoding((Object)ac.getValue());
    }

    public Object getArgValue(String name) {
        ArgumentConfig ac = (ArgumentConfig)this.args.get(name);
        if (ac == null) {
            return null;
        }
        return ac.getValue();
    }

    public boolean setArgStringValue(String name, String value) {
        if (value == null || value.equals("")) {
            this.args.remove(name);
            return true;
        }
        ArgumentConfig ac = (ArgumentConfig)this.args.get(name);
        if (ac == null) {
            return this.addArgStringValue(name, value);
        }
        if (ac.isFinal()) {
            throw new IllegalArgumentException("Cannot include final arguments as part of a test.");
        }
        StringReader sr = new StringReader(value);
        try {
            ac.setValue(ArgHelper.getArgumentInstance((String)ArgHelper.getArgumentType((Object)ac.getValue()), (String)value));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean addArgStringValue(String name, String value) {
        if (value == null || value.equals("")) {
            this.args.remove(name);
            return false;
        }
        PropertyDescriptor pd = this.getPropertyDescriptor(name);
        if (pd == null) {
            return false;
        }
        Class<?> cl = pd.getPropertyType();
        ArgumentConfig ac = new ArgumentConfig();
        ac.setName(name);
        try {
            ac.setValue(ArgHelper.getArgumentInstance((String)ArgHelper.getArgumentType(cl), (String)value));
        }
        catch (ValidationException e) {
            e.printStackTrace();
            return false;
        }
        this.args.put(name, ac);
        return true;
    }

    public Object createArg(String name, String value) throws Exception {
        PropertyDescriptor pd = this.getPropertyDescriptor(name);
        if (pd == null) {
            return null;
        }
        if (value == null || value.equals("")) {
            return null;
        }
        Class<?> cl = pd.getPropertyType();
        return ArgHelper.getArgumentInstance((String)ArgHelper.getArgumentType(cl), (String)value);
    }

    public boolean setArgValue(String name, Object value) {
        if (value == null || value.equals("")) {
            this.args.remove(name);
            return true;
        }
        ArgumentConfig ac = (ArgumentConfig)this.args.get(name);
        if (ac == null) {
            ac = new ArgumentConfig();
            ac.setName(name);
            this.args.put(name, ac);
        }
        if (ac.isFinal()) {
            throw new IllegalArgumentException("Cannot include final arguments as part of a test.");
        }
        ac.setValue(value);
        return true;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        try {
            Class<?> plugIn = this.getClass().getClassLoader().loadClass(this.className);
            BeanInfo bi = Introspector.getBeanInfo(plugIn);
            return bi.getPropertyDescriptors();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        if (name == null) {
            throw new NullPointerException("name must be defined to get a PropertyDescriptor.");
        }
        PropertyDescriptor[] pds = this.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            if (!name.equals(pds[i].getName())) continue;
            return pds[i];
        }
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

