/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.geoserver.feature.ReprojectingFilterVisitor;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Intersects;

public class ReprojectingFilterVisitorTest
extends TestCase {
    SimpleFeatureType ft;
    FilterFactory2 ff;
    ReprojectingFilterVisitor reprojector;

    protected void setUp() throws Exception {
        System.setProperty("org.geotools.referencing.forceXY", "true");
        this.ft = DataUtilities.createType((String)"testType", (String)"geom:Point:srid=4326,line:LineString,name:String,id:int");
        this.ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        this.reprojector = new ReprojectingFilterVisitor(this.ff, this.ft);
    }

    public void testNoProjection() {
        Id idFilter = this.ff.id(Collections.singleton(this.ff.featureId("testType:1")));
        Filter clone = (Filter)idFilter.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)idFilter, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)idFilter, (Object)clone);
    }

    public void testBboxNoReprojection() {
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 10.0, 20.0, 20.0, "EPSG:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)bbox, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)bbox, (Object)clone);
    }

    public void testBboxReproject() {
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 15.0, 20.0, 25.0, "urn:x-ogc:def:crs:EPSG:6.11.2:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)bbox, (Object)clone);
        BBOX clonedBbox = (BBOX)clone;
        ReprojectingFilterVisitorTest.assertEquals((String)bbox.getPropertyName(), (String)clonedBbox.getPropertyName());
        ReprojectingFilterVisitorTest.assertTrue((15.0 == clonedBbox.getMinX() ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((10.0 == clonedBbox.getMinY() ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((25.0 == clonedBbox.getMaxX() ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((20.0 == clonedBbox.getMaxY() ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertEquals((String)"EPSG:4326", (String)clonedBbox.getSRS());
    }

    public void testBboxReprojectUnreferencedProperty() {
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("line"), 10.0, 15.0, 20.0, 25.0, "urn:x-ogc:def:crs:EPSG:6.11.2:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)bbox, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)bbox, (Object)clone);
    }

    public void testBboxReprojectUnreferencedBBox() {
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 15.0, 20.0, 25.0, null);
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)bbox, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)bbox, (Object)clone);
    }

    public void testIntersectsReproject() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        ls.setUserData((Object)CRS.decode((String)"urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        Intersects original = this.ff.intersects((Expression)this.ff.property("geom"), (Expression)this.ff.literal((Object)ls));
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        Intersects isClone = (Intersects)clone;
        ReprojectingFilterVisitorTest.assertEquals((Object)isClone.getExpression1(), (Object)original.getExpression1());
        LineString clonedLs = (LineString)((Literal)isClone.getExpression2()).getValue();
        ReprojectingFilterVisitorTest.assertTrue((15.0 == clonedLs.getCoordinateN((int)0).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((10.0 == clonedLs.getCoordinateN((int)0).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((25.0 == clonedLs.getCoordinateN((int)1).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((20.0 == clonedLs.getCoordinateN((int)1).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)clonedLs.getUserData());
    }

    public void testIntersectsUnreferencedGeometry() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        Intersects original = this.ff.intersects((Expression)this.ff.property("geom"), (Expression)this.ff.literal((Object)ls));
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)original, (Object)clone);
    }

    public void testIntersectsUnreferencedProperty() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        ls.setUserData((Object)CRS.decode((String)"urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        Intersects original = this.ff.intersects((Expression)this.ff.property("line"), (Expression)this.ff.literal((Object)ls));
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)original, (Object)clone);
    }

    public void testPropertyEqualsFirstArgumentNotPropertyName() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        ls.setUserData((Object)CRS.decode((String)"urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        Function function = this.ff.function("geometryType", (Expression)this.ff.property("geom"));
        PropertyIsEqualTo original = this.ff.equals((Expression)this.ff.literal((Object)"Point"), (Expression)function);
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)original, (Object)clone);
        original = this.ff.equals((Expression)function, (Expression)this.ff.literal((Object)"Point"));
        clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)original, (Object)clone);
    }

    public void testIntersectsWithFunction() throws Exception {
        GeometryFunction function = new GeometryFunction();
        Intersects original = this.ff.intersects((Expression)this.ff.property("geom"), (Expression)function);
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        Intersects isClone = (Intersects)clone;
        ReprojectingFilterVisitorTest.assertEquals((Object)isClone.getExpression1(), (Object)original.getExpression1());
        LineString clonedLs = (LineString)isClone.getExpression2().evaluate(null);
        ReprojectingFilterVisitorTest.assertTrue((15.0 == clonedLs.getCoordinateN((int)0).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((10.0 == clonedLs.getCoordinateN((int)0).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((25.0 == clonedLs.getCoordinateN((int)1).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((20.0 == clonedLs.getCoordinateN((int)1).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)clonedLs.getUserData());
    }

    public void testPropertyEqualWithFunction() throws Exception {
        GeometryFunction function = new GeometryFunction();
        PropertyIsEqualTo original = this.ff.equals((Expression)this.ff.property("geom"), (Expression)function);
        PropertyIsEqualTo clone = (PropertyIsEqualTo)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)clone.getExpression1(), (Object)original.getExpression1());
        LineString clonedLs = (LineString)clone.getExpression2().evaluate(null);
        ReprojectingFilterVisitorTest.assertTrue((15.0 == clonedLs.getCoordinateN((int)0).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((10.0 == clonedLs.getCoordinateN((int)0).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((25.0 == clonedLs.getCoordinateN((int)1).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((20.0 == clonedLs.getCoordinateN((int)1).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)clonedLs.getUserData());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GeometryFunction
    implements Function {
        final LineString ls;

        public GeometryFunction() throws Exception {
            GeometryFactory gf = new GeometryFactory();
            this.ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
            this.ls.setUserData((Object)CRS.decode((String)"urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        }

        public String getName() {
            return "function";
        }

        public List<Expression> getParameters() {
            return Collections.EMPTY_LIST;
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            return visitor.visit((Function)this, extraData);
        }

        public Object evaluate(Object object) {
            return this.ls;
        }

        public <T> T evaluate(Object object, Class<T> context) {
            return (T)this.ls;
        }

        public Literal getFallbackValue() {
            return null;
        }
    }
}

