/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.geoserver.data.test.IOUtils;
import org.geoserver.data.test.LiveData;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.util.logging.Logging;

public class LiveDbmsData
extends LiveData {
    private static final Logger LOGGER = Logging.getLogger(LiveDbmsData.class);
    protected File fixture;
    protected List<String> filteredPaths = new ArrayList<String>(Arrays.asList("catalog.xml"));
    protected File sqlScript;
    protected DataStore ds;
    protected String fixtureId;

    public LiveDbmsData(File dataDirSourceDirectory, String fixtureId, File sqlScript) {
        super(dataDirSourceDirectory);
        this.fixture = this.lookupFixture(fixtureId);
        this.fixtureId = fixtureId;
        this.sqlScript = sqlScript;
    }

    private File lookupFixture(String fixtureId) {
        File fixtureFile;
        String property = System.getProperty("gs." + fixtureId);
        if (property != null && "false".equals(property.toLowerCase())) {
            return null;
        }
        File base = new File(System.getProperty("user.home"), ".geoserver");
        if (!base.exists()) {
            base.mkdir();
        }
        if (!(fixtureFile = new File(base, fixtureId + ".properties")).exists()) {
            String warning = "Disabling test based on fixture " + fixtureId + " since the file " + fixtureFile + " could not be found";
            this.disableTest(warning);
            return null;
        }
        return fixtureFile;
    }

    public boolean isTestDataAvailable() {
        return this.fixture != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        if (this.fixture == null) {
            return;
        }
        super.setUp();
        Properties p = new Properties();
        p.load(new FileInputStream(this.fixture));
        HashMap<Object, Object> filters = new HashMap<Object, Object>(p);
        if (this.filteredPaths != null && this.filteredPaths.size() > 0) {
            for (String path : this.filteredPaths) {
                File from = new File(this.source, path);
                File to = new File(this.data, path);
                IOUtils.filteredCopy(from, to, filters);
            }
        }
        if (this.sqlScript != null) {
            BufferedReader reader;
            Statement st;
            Connection conn;
            DataStore ds;
            block21: {
                block20: {
                    ds = null;
                    conn = null;
                    st = null;
                    reader = null;
                    ds = DataStoreFinder.getDataStore(filters);
                    if (ds != null) break block20;
                    String warning = "Disabling online test based on '" + this.fixtureId + "', " + "could not find a data store compatible " + "with the following connection properties: " + filters;
                    this.disableTest(warning);
                    JDBCUtils.close((Statement)st);
                    JDBCUtils.close((Connection)conn, null, null);
                    if (ds != null) {
                        ds.dispose();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                    return;
                }
                if (ds instanceof JDBCDataStore) {
                    conn = ((JDBCDataStore)ds).getConnection(Transaction.AUTO_COMMIT);
                }
                if (conn != null) break block21;
                String warning = "Disabling online test based on '" + this.fixtureId + "', " + "could not extract a JDBC connection from the datastore '" + ds.getClass() + " obtained using the following " + "connection properties: " + filters;
                this.disableTest(warning);
                JDBCUtils.close((Statement)st);
                JDBCUtils.close((Connection)conn, null, null);
                if (ds != null) {
                    ds.dispose();
                }
                if (reader != null) {
                    reader.close();
                }
                return;
            }
            try {
                reader = new BufferedReader(new FileReader(this.sqlScript));
                st = conn.createStatement();
                String command = null;
                while ((command = reader.readLine()) != null) {
                    if ("".equals(command = command.trim()) || command.startsWith("--") || command.startsWith("#")) continue;
                    try {
                        st.execute(command);
                    }
                    catch (SQLException e) {
                        LOGGER.warning("Error executing \"" + command + "\": " + e.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.close(st);
                JDBCUtils.close(conn, null, null);
                if (ds != null) {
                    ds.dispose();
                }
                if (reader != null) {
                    reader.close();
                }
                throw throwable;
            }
            JDBCUtils.close((Statement)st);
            JDBCUtils.close((Connection)conn, null, null);
            if (ds != null) {
                ds.dispose();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void disableTest(String warning) {
        LOGGER.warning(warning);
        this.fixture = null;
        System.setProperty("gs." + this.fixtureId, "false");
    }
}

