/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    private IOUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream from, File to) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(to);
            byte[] buffer = new byte[16384];
            int bytes = 0;
            while ((bytes = from.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytes);
            }
            out.flush();
        }
        finally {
            from.close();
            ((OutputStream)out).close();
        }
    }

    public static void filteredCopy(File from, File to, Map<String, String> filters) throws IOException {
        IOUtils.filteredCopy(new BufferedReader(new FileReader(from)), to, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filteredCopy(BufferedReader from, File to, Map<String, String> filters) throws IOException {
        BufferedWriter out = null;
        HashMap<String, String> escapedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            escapedMap.put("${" + entry.getKey() + "}", entry.getValue());
        }
        try {
            out = new BufferedWriter(new FileWriter(to));
            String line = null;
            while ((line = from.readLine()) != null) {
                for (Map.Entry entry : escapedMap.entrySet()) {
                    line = line.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                out.write(line);
                out.newLine();
            }
            out.flush();
        }
        finally {
            from.close();
            out.close();
        }
    }

    public static void copy(File from, File to) throws IOException {
        IOUtils.copy(new FileInputStream(from), to);
    }

    public static void deepCopy(File fromDir, File toDir) throws IOException {
        File[] files;
        if (!fromDir.isDirectory() || !fromDir.exists()) {
            throw new IllegalArgumentException("Invalid source directory (it's either not a directory, or does not exist");
        }
        if (toDir.exists() && toDir.isFile()) {
            throw new IllegalArgumentException("Invalid destination directory, it happens to be a file instead");
        }
        if (!toDir.exists() && !toDir.mkdir()) {
            throw new IOException("Could not create " + toDir);
        }
        for (File file : files = fromDir.listFiles()) {
            File destination = new File(toDir, file.getName());
            if (file.isDirectory()) {
                IOUtils.deepCopy(file, destination);
                continue;
            }
            IOUtils.copy(file, destination);
        }
    }

    public static File createRandomDirectory(String baseDir, String prefix, String suffix) throws IOException {
        File tempDir = File.createTempFile(prefix, suffix, new File(baseDir));
        tempDir.delete();
        if (!tempDir.mkdir()) {
            throw new IOException("Could not create the temp directory " + tempDir.getPath());
        }
        return tempDir;
    }

    public static void delete(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " does not appear to be a directory at all...");
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                IOUtils.delete(files[i]);
                continue;
            }
            if (files[i].delete()) continue;
            System.out.println("Could not delete " + files[i].getAbsolutePath());
        }
        directory.delete();
    }
}

