/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.geoserver.data.DefaultGeoServerCatalog;
import org.geoserver.data.GeoServerCatalog;
import org.geoserver.data.GeoServerServiceFinder;
import org.geotools.catalog.Service;
import org.geotools.catalog.property.PropertyServiceFactory;
import org.geotools.data.property.PropertyDataStoreFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class DataTestSupport
extends TestCase {
    public static String BASIC_POLYGONS_TYPE = "BasicPolygons";
    public static String BRIDGES_TYPE = "Bridges";
    public static String BUILDINGS_TYPE = "Buildings";
    public static String DIVIDED_ROUTES_TYPE = "DividedRoutes";
    public static String FORESTS_TYPE = "Forests";
    public static String LAKES_TYPE = "Lakes";
    public static String MAP_NEATLINE_TYPE = "MapNeatline";
    public static String NAMED_PLACES_TYPE = "NamedPlaces";
    public static String PONDS_TYPE = "Ponds";
    public static String ROAD_SEGMENTS_TYPE = "RoadSegments";
    public static String STREAMS_TYPE = "Streams";
    public static String CITE_PREFIX = "cite";
    public static String CITE_URI = "http://www.opengis.net/cite";
    File tmp;
    protected GeoServerCatalog catalog;
    static /* synthetic */ Class class$0;

    protected void setUp() throws Exception {
        this.tmp = File.createTempFile("cite", "test");
        this.tmp.delete();
        this.tmp.mkdir();
        this.copy(BASIC_POLYGONS_TYPE);
        this.copy(BRIDGES_TYPE);
        this.copy(BUILDINGS_TYPE);
        this.copy(DIVIDED_ROUTES_TYPE);
        this.copy(FORESTS_TYPE);
        this.copy(LAKES_TYPE);
        this.copy(MAP_NEATLINE_TYPE);
        this.copy(NAMED_PLACES_TYPE);
        this.copy(PONDS_TYPE);
        this.copy(ROAD_SEGMENTS_TYPE);
        this.copy(STREAMS_TYPE);
        this.catalog = this.createCiteCatalog();
    }

    void copy(String type) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.geoserver.data.DataTestSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream from = clazz.getResourceAsStream("data/" + type + ".properties");
        File to = new File(this.tmp, String.valueOf(type) + ".properties");
        BufferedInputStream in = new BufferedInputStream(from);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(to));
        int b = 0;
        while ((b = ((InputStream)in).read()) != -1) {
            ((OutputStream)out).write(b);
        }
        ((InputStream)in).close();
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }

    protected GeoServerCatalog createCiteCatalog() {
        DefaultGeoServerCatalog catalog = new DefaultGeoServerCatalog();
        GeoServerServiceFinder finder = new GeoServerServiceFinder(catalog);
        PropertyServiceFactory factory = new PropertyServiceFactory();
        GenericApplicationContext context = new GenericApplicationContext();
        context.getBeanFactory().registerSingleton("finder", (Object)finder);
        context.getBeanFactory().registerSingleton("psf", (Object)factory);
        finder.setApplicationContext((ApplicationContext)context);
        HashMap<String, File> params = new HashMap<String, File>();
        params.put(PropertyDataStoreFactory.DIRECTORY.key, this.tmp);
        List services = finder.aquire(params);
        catalog.add((Service)services.get(0));
        catalog.getNamespaceSupport().declarePrefix("", CITE_URI);
        catalog.getNamespaceSupport().declarePrefix(CITE_PREFIX, CITE_URI);
        return catalog;
    }

    protected void tearDown() throws Exception {
        File[] files = this.tmp.listFiles();
        int i = 0;
        while (i < files.length) {
            files[i].delete();
            ++i;
        }
        this.tmp.delete();
    }

    protected String[] citeTypeNames() {
        return new String[]{BASIC_POLYGONS_TYPE, BRIDGES_TYPE, BUILDINGS_TYPE, DIVIDED_ROUTES_TYPE, FORESTS_TYPE, LAKES_TYPE, MAP_NEATLINE_TYPE, NAMED_PLACES_TYPE, PONDS_TYPE, ROAD_SEGMENTS_TYPE, STREAMS_TYPE};
    }
}

