/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.util.ReaderUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CatalogReader {
    Element catalog;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            this.catalog = ReaderUtils.parse((Reader)reader);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            reader.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        reader.close();
    }

    public List dataStores() throws Exception {
        Element dataStoresElement = ReaderUtils.getChildElement((Element)this.catalog, (String)"datastores", (boolean)true);
        NodeList dataStoreElements = dataStoresElement.getElementsByTagName("datastore");
        ArrayList<Map> dataStores = new ArrayList<Map>();
        int i = 0;
        while (i < dataStoreElements.getLength()) {
            Element dataStoreElement = (Element)dataStoreElements.item(i);
            try {
                Map params = this.dataStoreParams(dataStoreElement);
                dataStores.add(params);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return dataStores;
    }

    public Map namespaces() throws Exception {
        Element namespacesElement = ReaderUtils.getChildElement((Element)this.catalog, (String)"namespaces", (boolean)true);
        NodeList namespaceElements = namespacesElement.getElementsByTagName("namespace");
        HashMap namespaces = new HashMap();
        int i = 0;
        while (i < namespaceElements.getLength()) {
            Element namespaceElement = (Element)namespaceElements.item(i);
            try {
                Map.Entry tuple = this.namespaceTuple(namespaceElement);
                namespaces.put(tuple.getKey(), tuple.getValue());
                if ("true".equals(namespaceElement.getAttribute("default"))) {
                    namespaces.put("", tuple.getValue());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return namespaces;
    }

    protected Map dataStoreParams(Element dataStoreElement) throws Exception {
        Element paramsElement = ReaderUtils.getChildElement((Element)dataStoreElement, (String)"connectionParameters", (boolean)true);
        NodeList paramList = paramsElement.getElementsByTagName("parameter");
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < paramList.getLength()) {
            Element paramElement = (Element)paramList.item(i);
            String key = ReaderUtils.getAttribute((Element)paramElement, (String)"name", (boolean)true);
            String value = ReaderUtils.getAttribute((Element)paramElement, (String)"value", (boolean)true);
            params.put(key, value);
            ++i;
        }
        return params;
    }

    protected Map.Entry namespaceTuple(Element namespaceElement) throws Exception {
        final String pre = namespaceElement.getAttribute("prefix");
        final String uri = namespaceElement.getAttribute("uri");
        return new Map.Entry(){

            public Object getKey() {
                return pre;
            }

            public Object getValue() {
                return uri;
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

