/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geoserver.data.CatalogReader;
import org.geoserver.data.GeoServerCatalog;
import org.geotools.catalog.Service;
import org.geotools.catalog.ServiceFinder;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class CatalogLoader
implements ResourceLoaderAware,
InitializingBean,
DisposableBean {
    GeoServerCatalog catalog;
    ServiceFinder finder;
    ResourceLoader loader;

    public CatalogLoader(GeoServerCatalog catalog, ServiceFinder finder) {
        this.catalog = catalog;
        this.finder = finder;
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.loader = loader;
    }

    public void afterPropertiesSet() throws Exception {
        Resource resource = this.loader.getResource("classpath:catalog.xml");
        if (!resource.exists()) {
            String msg = "Could not find catalog.xml";
            throw new Exception(msg);
        }
        File catalogFile = resource.getFile();
        CatalogReader reader = new CatalogReader();
        reader.read(catalogFile);
        Iterator d = reader.dataStores().iterator();
        while (d.hasNext()) {
            Map params = (Map)d.next();
            List services = this.finder.aquire(params);
            Iterator s = services.iterator();
            while (s.hasNext()) {
                this.catalog.add((Service)s.next());
            }
        }
        Map nsMappings = reader.namespaces();
        Iterator ns = nsMappings.entrySet().iterator();
        while (ns.hasNext()) {
            Map.Entry nsMapping = ns.next();
            String pre = (String)nsMapping.getKey();
            String uri = (String)nsMapping.getValue();
            this.catalog.getNamespaceSupport().declarePrefix(pre, uri);
        }
    }

    public void destroy() throws Exception {
    }
}

