/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.homology.service.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.geneweaver.homology.service.dao.HomologyRow;
import org.geneweaver.homology.service.function.ParseException;
import org.geneweaver.homology.service.io.Expander;
import org.springframework.stereotype.Service;

@Service
public class HomologyParser
implements Iterable<HomologyRow>,
AutoCloseable {
    public static final String[] HEADERS = new String[]{"hom_id", "hom_source_id", "hom_source_name", "ode_gene_id", "sp_id", "hom_date"};
    private Scanner scanner;
    private Expander expander;

    public HomologyParser() {
    }

    public HomologyParser(File file) throws IOException {
        this();
        this.link(file);
    }

    public AutoCloseable link(File csv) throws IOException {
        this.link(csv, HEADERS);
        return this;
    }

    public void link(File csv, String[] headers) throws IOException, ParseException {
        if (csv.length() <= 0L) {
            throw new ParseException("Cannot parse empty file: " + csv);
        }
        if (csv.getName().toLowerCase().endsWith(".zip")) {
            this.expander = new Expander();
            List<Path> paths = this.expander.expand(csv.toPath());
            if (paths.size() != 1) {
                throw new ParseException("Either a csv file or a zip file with one csv file in it is currently supported.\nPlease contact you support representative if you would like to support more than one csv.");
            }
            csv = paths.get(0).toFile();
        }
        this.scanner = new Scanner(csv);
        this.nextLine();
        assert (this.scanner.hasNextLine());
    }

    private String nextLine() {
        String line = null;
        while ((line = this.scanner.nextLine().trim()) != null) {
            if (line.startsWith("#")) continue;
            return line;
        }
        return line;
    }

    @Override
    public Iterator<HomologyRow> iterator() {
        return new RowIterator();
    }

    public Iterator<List<HomologyRow>> chunkIterator(int chunkSize) {
        return new ChunkIterator(chunkSize);
    }

    @Override
    public void close() {
        if (this.expander != null) {
            this.expander.close();
        }
        if (this.scanner != null) {
            this.scanner.close();
        }
    }

    public int size(File file) throws IOException {
        this.link(file);
        int size = 0;
        while (this.scanner.hasNextLine()) {
            this.nextLine();
            ++size;
        }
        this.close();
        return size;
    }

    private class RowIterator
    implements Iterator<HomologyRow> {
        private RowIterator() {
        }

        @Override
        public boolean hasNext() {
            return HomologyParser.this.scanner.hasNextLine();
        }

        @Override
        public HomologyRow next() {
            return HomologyRow.create(HomologyParser.this.nextLine());
        }
    }

    private class ChunkIterator
    implements Iterator<List<HomologyRow>> {
        private Iterator<HomologyRow> r;
        private List<HomologyRow> chunk;
        private int chunkSize;

        public ChunkIterator(int chunkSize) {
            this.chunkSize = chunkSize;
            this.r = HomologyParser.this.iterator();
            this.chunk = new ArrayList<HomologyRow>(chunkSize);
        }

        @Override
        public boolean hasNext() {
            return this.r.hasNext();
        }

        @Override
        public List<HomologyRow> next() {
            this.chunk.clear();
            for (int i = 0; i < this.chunkSize && this.r.hasNext(); ++i) {
                this.chunk.add(this.r.next());
            }
            return this.chunk;
        }
    }
}

