/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.homology.service.function;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import org.geneweaver.homology.service.dao.HomologyRow;
import org.geneweaver.homology.service.db.HomologyRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class ODEQueryFunction {
    private static final Logger logger = Logger.getLogger(ODEQueryFunction.class.getName());
    @Autowired
    private HomologyRepository repo;
    private static final ObjectMapper mapper = new ObjectMapper();

    @Bean(name={"ode-query"})
    public Function<Long, String> odeGeneQuery() {
        return odeGeneId -> {
            logger.info("Called ode lookup " + odeGeneId);
            try {
                ObjectWriter writer = mapper.writer();
                if ("true".equals(System.getenv().getOrDefault("PRETTY_PRINT", "false"))) {
                    writer = mapper.writerWithDefaultPrettyPrinter();
                }
                return writer.writeValueAsString(this.repo.odeSearch((Long)odeGeneId));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return "{\"ERROR\" : \"" + e.getMessage() + "\"}";
            }
        };
    }

    private List<HomologyRow> createTestList() {
        HomologyRow one = new HomologyRow(1L, 2L, "Fred", 31L, 1L, new Date(10000L));
        HomologyRow two = new HomologyRow(1L, 2L, "Bill", 31L, 1L, new Date(10000L));
        return Arrays.asList(one, two);
    }

    static {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        mapper.setDateFormat((DateFormat)df);
    }
}

