/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.homology.service.function;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.geneweaver.homology.service.dao.HomologyRow;
import org.geneweaver.homology.service.db.HomologyRepository;
import org.geneweaver.homology.service.function.Downloader;
import org.geneweaver.homology.service.function.GCSEvent;
import org.geneweaver.homology.service.function.ImportFunction;
import org.geneweaver.homology.service.function.ParseException;
import org.geneweaver.homology.service.io.HomologyParser;

public class ImportConsumer
implements Consumer<GCSEvent> {
    public static final int chunkSize = Integer.parseInt(System.getenv().getOrDefault("CHUNK_SIZE", "1000"));
    private static final Logger logger = Logger.getLogger(ImportFunction.class.getName());
    private HomologyRepository repo;
    private HomologyParser parser;

    public ImportConsumer(HomologyRepository repo, HomologyParser parser) {
        this.repo = repo;
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(GCSEvent event) {
        this.validate(event);
        logger.info("Bucket: " + event.getBucket());
        logger.info("File: " + event.getName());
        try {
            Path source = Downloader.download(event);
            try {
                this.parser.link(source.toFile());
                Iterator<List<HomologyRow>> it = this.parser.chunkIterator(chunkSize);
                int saved = 0;
                while (it.hasNext()) {
                    List<HomologyRow> items = it.next();
                    this.repo.saveAll(items);
                    logger.info("Saved '" + (saved += items.size()) + "' records to 'homology' table.");
                }
            }
            finally {
                this.parser.close();
                Files.delete(source);
            }
            logger.info("Imported: " + event.getName());
        }
        catch (Exception ne) {
            throw new ParseException(ne);
        }
    }

    private void validate(GCSEvent event) throws ParseException {
        if (event == null) {
            throw new ParseException("No context provided!");
        }
        if (!Boolean.getBoolean("homology.service.function.direct.file") && (event.getBucket() == null || event.getBucket().isEmpty())) {
            throw new ParseException("No bucket provided from which to partition!");
        }
        if (event.getName() == null || event.getName().isEmpty()) {
            throw new ParseException("No file provided to partition!");
        }
    }
}

