/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.homology.service.function;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geneweaver.homology.service.function.GCSEvent;

public class Downloader {
    private static final Logger logger = Logger.getLogger(Downloader.class.getName());

    public static final Path download(GCSEvent event) throws IOException {
        boolean directFile = Boolean.getBoolean("homology.service.function.direct.file");
        String baseName = FilenameUtils.getBaseName((String)event.getName());
        String ext = FilenameUtils.getExtension((String)event.getName());
        Path source = Files.createTempFile(baseName, "." + ext, new FileAttribute[0]);
        if (!directFile) {
            Storage storage = (Storage)StorageOptions.getDefaultInstance().getService();
            Bucket bucket = storage.get(event.getBucket(), new Storage.BucketGetOption[0]);
            Blob blob = bucket.get(event.getName(), new Storage.BlobGetOption[0]);
            blob.downloadTo(source);
        } else {
            logger.info("Direct file mode is set, we are testing this csv-import function.");
            Path blob = Paths.get(event.getName(), new String[0]);
            Files.copy(blob, source, StandardCopyOption.REPLACE_EXISTING);
        }
        return source;
    }
}

