/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.homology.service.dao;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.sql.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.geneweaver.homology.service.function.ParseException;

@Entity
@Table(name="HOMOLOGY")
public class HomologyRow {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    @JsonProperty(value="id")
    private Long uid;
    @Column(name="hom_id")
    @JsonProperty(value="hom_id")
    private Long homologyId;
    @Column(name="hom_source_id")
    @JsonProperty(value="hom_source_id")
    private Long sourceId;
    @Column(name="hom_source_name")
    @JsonProperty(value="hom_source_name")
    private String sourceName;
    @Column(name="ode_gene_id")
    @JsonProperty(value="ode_gene_id")
    private Long odeGeneId;
    @Column(name="sp_id")
    @JsonProperty(value="sp_id")
    private Long speciesId;
    @Column(name="hom_date")
    @JsonProperty(value="hom_date")
    private Date date;

    public HomologyRow() {
    }

    public HomologyRow(Long homologyId, Long sourceId, String sourceName, Long odeGeneId, Long speciesId, Date date) {
        this.homologyId = homologyId;
        this.sourceId = sourceId;
        this.sourceName = sourceName;
        this.odeGeneId = odeGeneId;
        this.speciesId = speciesId;
        this.date = date;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public HomologyRow setSourceId(Long sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public HomologyRow setSourceName(String sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    public Long getOdeGeneId() {
        return this.odeGeneId;
    }

    public HomologyRow setOdeGeneId(Long odeGeneId) {
        this.odeGeneId = odeGeneId;
        return this;
    }

    public Long getSpeciesId() {
        return this.speciesId;
    }

    public HomologyRow setSpeciesId(Long speciesId) {
        this.speciesId = speciesId;
        return this;
    }

    public Date getDate() {
        return this.date;
    }

    public HomologyRow setDate(Date date) {
        this.date = date;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.date, this.homologyId, this.odeGeneId, this.sourceId, this.sourceName, this.speciesId, this.uid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HomologyRow)) {
            return false;
        }
        HomologyRow other = (HomologyRow)obj;
        return Objects.equals(this.date, other.date) && Objects.equals(this.homologyId, other.homologyId) && Objects.equals(this.odeGeneId, other.odeGeneId) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.sourceName, other.sourceName) && Objects.equals(this.speciesId, other.speciesId) && Objects.equals(this.uid, other.uid);
    }

    public static HomologyRow create(String csvLine) throws ParseException {
        HomologyRow row = new HomologyRow();
        String[] segs = csvLine.split(",");
        for (int i = 0; i < segs.length; ++i) {
            segs[i] = segs[i].trim();
        }
        row.homologyId = Long.parseLong(segs[0]);
        row.sourceId = Long.parseLong(segs[1]);
        row.sourceName = segs[2];
        row.odeGeneId = Long.parseLong(segs[3]);
        row.speciesId = Long.parseLong(segs[4]);
        row.date = Date.valueOf(segs[5]);
        return row;
    }

    public Long getUid() {
        return this.uid;
    }

    public HomologyRow setUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public Long getHomologyId() {
        return this.homologyId;
    }

    public HomologyRow setHomologyId(Long homologyId) {
        this.homologyId = homologyId;
        return this;
    }

    public String toString() {
        return "HomologyRow [uid=" + this.uid + ", homologyId=" + this.homologyId + ", sourceId=" + this.sourceId + ", sourceName=" + this.sourceName + ", odeGeneId=" + this.odeGeneId + ", speciesId=" + this.speciesId + ", date=" + this.date + "]";
    }
}

