/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.homology.service.controller;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.geneweaver.domain.Gene;
import org.geneweaver.homology.service.controller.EnsemblException;
import org.geneweaver.homology.service.controller.EnsemblRequest;
import org.geneweaver.homology.service.controller.EnsemblResponse;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderFactory;
import org.geneweaver.io.reader.ReaderRequest;
import org.geneweaver.io.reader.StreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Mono;

@Service
public class EnsemblRestService {
    private static Logger logger = LoggerFactory.getLogger(EnsemblRestService.class);
    private static final String restUri = System.getProperty("rest.homolog.uri", "http://rest.ensembl.org");
    private WebClient client = WebClient.builder().baseUrl(restUri).defaultHeader("Content-Type", new String[]{"application/json"}).build();

    public EnsemblResponse retrieve(EnsemblRequest request) {
        if (request.getGeneId() == null || request.getGeneId().isEmpty()) {
            throw new IllegalArgumentException("The geneId must be provided!");
        }
        try {
            Mono response = this.client.get().uri(builder -> request.build((UriBuilder)builder)).retrieve().bodyToMono(JsonNode.class);
            JsonNode node = (JsonNode)response.block();
            JsonNode data = node.get("data");
            JsonNode homols = data.get(0).get("homologies");
            return new EnsemblResponse(request.getGeneId(), StreamSupport.stream(homols.spliterator(), false).map(n -> request.extractor().apply((JsonNode)n)), request.getDelimiter());
        }
        catch (WebClientResponseException web) {
            if (web.getRawStatusCode() == 429) {
                int antiSwampTime = Integer.getInteger("org.geneweaver.homology.service.antiSwamp", 500);
                try {
                    Thread.sleep(antiSwampTime);
                }
                catch (InterruptedException e) {
                    logger.error("Cannot sleep", (Throwable)e);
                }
                return this.retrieve(request);
            }
            return EnsemblResponse.empty();
        }
        catch (Exception ne) {
            logger.info("Cannot get homologs for " + request, (Throwable)ne);
            return EnsemblResponse.empty();
        }
    }

    public EnsemblResponse generate(EnsemblRequest request) throws EnsemblException {
        StreamReader reader;
        if (request.getFile() == null || !request.getFile().exists()) {
            throw new EnsemblException("Input file from which to generate not found!");
        }
        try {
            reader = ReaderFactory.getReader((ReaderRequest)new ReaderRequest(request.getFromSpecies(), request.getFile()));
        }
        catch (ReaderException e) {
            throw new EnsemblException(e);
        }
        try {
            Stream<String> maps = reader.stream().filter(g -> g != null).filter(g -> g instanceof Gene).map(g -> g.getGeneId()).flatMap(id -> {
                request.setGeneId((String)id);
                return this.flatten(request);
            });
            return new EnsemblResponse(request.getGeneId(), maps, request.getDelimiter());
        }
        catch (ReaderException e) {
            throw new EnsemblException(e);
        }
    }

    private Stream<String> flatten(EnsemblRequest req) {
        EnsemblResponse res = this.retrieve(req);
        Stream<String> lines = res.getLines();
        if (req.isReverse()) {
            return lines.map(val -> val + res.getDelimiter() + req.getGeneId());
        }
        return lines.map(val -> req.getGeneId() + res.getDelimiter() + val);
    }

    public static void main(String[] args) throws Exception {
        File path = Paths.get("/Volumes/jax-data/data/variant-orthology/Homo_sapiens.GRCh38.91.gtf.gz", new String[0]).toFile();
        EnsemblRestService service = new EnsemblRestService();
        EnsemblResponse res = service.generate(new EnsemblRequest("Homo sapiens", path, ","));
        Stream<String> lines = res.getLines();
        Path file = Paths.get("./tmp/orthologs.csv", new String[0]);
        file.getParent().toFile().mkdirs();
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            lines.forEach(line -> {
                try {
                    writer.write((String)line);
                    writer.newLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }
}

