/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.homology.service.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnsemblResponse {
    private String geneId;
    private Stream<String> lines;
    private String delimiter = ",";

    EnsemblResponse(String geneId, Stream<String> lines, String delimiter) {
        this.geneId = geneId;
        this.lines = lines;
        this.delimiter = delimiter;
    }

    public Map<String, Collection<String>> retrieveEntry() {
        Collection homs = this.lines.collect(Collectors.toSet());
        HashMap<String, Collection<String>> ret = new HashMap<String, Collection<String>>(1);
        ret.put(this.geneId, homs);
        return ret;
    }

    public Stream<String> getLines() {
        return this.lines;
    }

    public void setLines(Stream<String> lines) {
        this.lines = lines;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public long count() {
        return this.lines.count();
    }

    public Collection<String> collect() {
        return this.getLines().collect(Collectors.toSet());
    }

    public String getGeneId() {
        return this.geneId;
    }

    public void setGeneId(String fromGene) {
        this.geneId = fromGene;
    }

    static EnsemblResponse empty() {
        return new EnsemblResponse(null, Stream.empty(), null);
    }
}

