/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.homology.service.controller;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.web.util.UriBuilder;

public class EnsemblRequest {
    private static final Map<String, Function<JsonNode, String>> extractors = new HashMap<String, Function<JsonNode, String>>();
    private String fromSpecies;
    private File file;
    private String delimiter = ",";
    private String geneId;
    private String targetSpecies;
    private int targetTaxon = -1;
    private String format = "condensed";
    private String type = "orthologues";
    private boolean reverse = false;

    public EnsemblRequest() {
    }

    public EnsemblRequest(String fromSpecies, File file, String delimiter) {
        this.fromSpecies = fromSpecies;
        this.file = file;
        this.delimiter = delimiter;
    }

    public Function<JsonNode, String> extractor() {
        return extractors.get(this.getFormat().toLowerCase());
    }

    public int getTargetTaxon() {
        return this.targetTaxon;
    }

    public void setTargetTaxon(int targetTaxon) {
        this.targetTaxon = targetTaxon;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTargetSpecies() {
        return this.targetSpecies;
    }

    public void setTargetSpecies(String targetSpecies) {
        this.targetSpecies = targetSpecies;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public void setGeneId(String geneId) {
        this.geneId = geneId;
    }

    public int hashCode() {
        return Objects.hash(this.delimiter, this.file, this.format, this.fromSpecies, this.geneId, this.reverse, this.targetSpecies, this.targetTaxon, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EnsemblRequest)) {
            return false;
        }
        EnsemblRequest other = (EnsemblRequest)obj;
        return Objects.equals(this.delimiter, other.delimiter) && Objects.equals(this.file, other.file) && Objects.equals(this.format, other.format) && Objects.equals(this.fromSpecies, other.fromSpecies) && Objects.equals(this.geneId, other.geneId) && this.reverse == other.reverse && Objects.equals(this.targetSpecies, other.targetSpecies) && this.targetTaxon == other.targetTaxon && Objects.equals(this.type, other.type);
    }

    @JsonIgnore
    public URI build(UriBuilder builder) {
        HashMap<String, String> uv = new HashMap<String, String>();
        uv.put("geneId", this.geneId);
        builder = builder.path("/homology/id/{geneId}");
        if (this.format != null) {
            builder = builder.queryParam("format", new Object[]{"{format}"});
            uv.put("format", this.format);
        }
        if (this.type != null) {
            builder = builder.queryParam("type", new Object[]{"{type}"});
            uv.put("type", this.type);
        }
        if (this.targetTaxon > 0) {
            builder = builder.queryParam("target_taxon", new Object[]{"{target_taxon}"});
            uv.put("target_taxon", String.valueOf(this.targetTaxon));
        }
        if (this.targetSpecies != null) {
            builder = builder.queryParam("target_species", new Object[]{"{target_species}"});
            uv.put("target_species", this.targetSpecies);
        }
        URI uri = builder.build(uv);
        return uri;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getFromSpecies() {
        return this.fromSpecies;
    }

    public void setFromSpecies(String species) {
        this.fromSpecies = species;
    }

    public static EnsemblRequest toMouse(String geneId) {
        EnsemblRequest req = new EnsemblRequest();
        req.setGeneId(geneId);
        req.setTargetTaxon(10090);
        return req;
    }

    public static EnsemblRequest toSpecies(String geneId, String species) {
        EnsemblRequest req = new EnsemblRequest();
        req.setGeneId(geneId);
        req.setTargetSpecies(species);
        return req;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    static {
        extractors.put("condensed", n -> n.get("id").asText());
        extractors.put("full", n -> n.get("target").get("id").asText());
    }
}

