/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.tokenauth.spring;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.genesys.blocks.tokenauth.spring.ApiTokenAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class ApiTokenAuthenticationFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(ApiTokenAuthenticationFilter.class);
    private static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String AUTHORIZATION_TYPE = "API-Token";
    private RequestMatcher requiresAuthenticationRequestMatcher;
    private AuthenticationManager authenticationManager;
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

    public ApiTokenAuthenticationFilter(RequestMatcher requiresAuth, AuthenticationManager authenticationManager) {
        this.requiresAuthenticationRequestMatcher = requiresAuth;
        this.authenticationManager = authenticationManager;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.requiresAuthentication(request, response)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            Authentication authenticationResult = this.attemptAuthentication(request, response);
            if (authenticationResult == null) {
                return;
            }
            this.successfulAuthentication(request, response, chain, authenticationResult);
        }
        catch (InternalAuthenticationServiceException failed) {
            log.error("An internal error occurred while trying to authenticate the user.", (Throwable)failed);
            this.unsuccessfulAuthentication(request, response, (AuthenticationException)((Object)failed));
        }
        catch (AuthenticationException ex) {
            this.unsuccessfulAuthentication(request, response, ex);
        }
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        SecurityContext context = this.securityContextHolderStrategy.createEmptyContext();
        context.setAuthentication(authResult);
        this.securityContextHolderStrategy.setContext(context);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) {
        this.securityContextHolderStrategy.clearContext();
        log.trace("Failed to process authentication request", (Throwable)failed);
        log.trace("Cleared SecurityContextHolder");
        log.trace("Handling authentication failure");
        response.addHeader("WWW-Authenticate", "Invalid API-Token");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
    }

    protected boolean requiresAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Optional<String> tokenParam;
        if (this.requiresAuthenticationRequestMatcher.matches(httpServletRequest) && (tokenParam = Optional.ofNullable(httpServletRequest.getHeader(AUTHORIZATION_HEADER))).isPresent()) {
            return StringUtils.startsWithIgnoreCase((CharSequence)tokenParam.get(), (CharSequence)AUTHORIZATION_TYPE);
        }
        return false;
    }

    public Authentication attemptAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws AuthenticationException, IOException, ServletException {
        String token = httpServletRequest.getHeader(AUTHORIZATION_HEADER);
        log.trace("Have {} header: {}", (Object)AUTHORIZATION_HEADER, (Object)token);
        token = StringUtils.removeStartIgnoreCase((String)token, (String)AUTHORIZATION_TYPE).trim();
        if (token.length() == 0) {
            throw new AuthenticationCredentialsNotFoundException("Invalid API token");
        }
        log.debug("Received {} token: {}", (Object)AUTHORIZATION_TYPE, (Object)token);
        return this.authenticationManager.authenticate((Authentication)new ApiTokenAuthenticationToken(token));
    }
}

