/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.tokenauth.service.impl;

import java.time.Instant;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.genesys.blocks.security.model.AclSid;
import org.genesys.blocks.tokenauth.model.ApiToken;
import org.genesys.blocks.tokenauth.persistence.ApiTokenPersistence;
import org.genesys.blocks.tokenauth.service.ApiTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApiTokenServiceImpl
implements ApiTokenService {
    private static final Logger log = LoggerFactory.getLogger(ApiTokenServiceImpl.class);
    @Value(value="${apitoken.salt:hellothere}")
    private String tokenSalt;
    @Autowired
    private ApiTokenPersistence apiTokenPersistence;

    @Override
    @Cacheable(cacheNames={"api.tokenauth.encoded"}, key="#token", unless="#result == null")
    public String encodeToken(@NonNull String token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        log.debug("Encoding token {}", (Object)token);
        return Base64.encodeBase64String((byte[])DigestUtils.sha256((String)this.tokenSalt.concat(token)));
    }

    @Override
    @Transactional(readOnly=true)
    @PostAuthorize(value="hasRole('ADMINISTRATOR') || returnObject.sid.id == principal.id")
    public ApiToken loadById(Long id) {
        return this.apiTokenPersistence.findById(id).orElse(null);
    }

    @Override
    @Transactional(readOnly=true)
    @Cacheable(cacheNames={"api.tokenauth.tokens"}, key="#encodedToken", unless="#result == null")
    public ApiToken getToken(String encodedToken) {
        log.debug("Loading token from database {}", (Object)encodedToken);
        return this.apiTokenPersistence.findByToken(encodedToken).orElse(null);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') || (hasRole('VETTEDUSER') && #sid.id == principal.id)")
    public List<ApiToken> listTokensForSid(AclSid sid) {
        return this.apiTokenPersistence.findAllBySid(sid);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public Page<ApiToken> listTokens(Pageable page) {
        return this.apiTokenPersistence.findAll(page);
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR') || (hasRole('VETTEDUSER') && #sid.id == principal.id)")
    public ApiToken createToken(AclSid sid, String label, Instant expires) {
        ApiToken apiToken = new ApiToken();
        apiToken.setSid(sid);
        apiToken.setExpires(expires);
        apiToken.setLabel(label);
        String token = null;
        for (int i = 0; i < 10; ++i) {
            token = UUID.randomUUID().toString();
            apiToken.setToken(this.encodeToken(token));
            if (this.apiTokenPersistence.findByToken(apiToken.getToken()).isEmpty()) break;
            log.info("Token already exists, generating a new one");
        }
        ApiToken saved = (ApiToken)((Object)this.apiTokenPersistence.save((Object)apiToken));
        saved.setToken(token);
        log.info("Created a new token for {} with label={} expires={}", new Object[]{apiToken.getSid().getSid(), apiToken.getLabel(), apiToken.getExpires()});
        return saved;
    }

    @Override
    @Transactional
    @PostAuthorize(value="hasRole('ADMINISTRATOR') || (hasRole('VETTEDUSER') && returnObject.sid.id == principal.id)")
    @CacheEvict(cacheNames={"api.tokenauth.tokens"}, key="#result.token", condition="#result != null")
    public ApiToken remove(ApiToken apiToken) {
        assert (apiToken != null && apiToken.getId() != null);
        ApiToken token = this.apiTokenPersistence.findById(apiToken.getId()).orElse(null);
        if (token == null) {
            return null;
        }
        log.info("Deleting token for {} with label={}", (Object)token.getSid().getSid(), (Object)token.getLabel());
        this.apiTokenPersistence.delete((Object)token);
        return token;
    }

    @Override
    @Transactional
    @PostAuthorize(value="hasRole('ADMINISTRATOR') || (hasRole('VETTEDUSER') && returnObject.sid.id == principal.id)")
    @CacheEvict(cacheNames={"api.tokenauth.tokens"}, key="#result.token", condition="#result != null")
    public ApiToken update(ApiToken apiToken) {
        ApiToken toUpdate = this.apiTokenPersistence.findById(apiToken.getId()).orElse(null);
        if (toUpdate == null) {
            return null;
        }
        log.info("Updating token for {} with label={}", (Object)toUpdate.getSid().getSid(), (Object)toUpdate.getLabel());
        toUpdate.apply((Object)apiToken);
        return (ApiToken)((Object)this.apiTokenPersistence.save((Object)toUpdate));
    }
}

