/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.tokenauth.model;

import com.fasterxml.jackson.annotation.JsonView;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.genesys.blocks.annotations.NotCopyable;
import org.genesys.blocks.model.AuditedVersionedModel;
import org.genesys.blocks.model.Copyable;
import org.genesys.blocks.model.JsonViews;
import org.genesys.blocks.security.model.AclSid;

@Entity
@Table(name="api_token", indexes={@Index(name="apitoken_token", columnList="token", unique=true), @Index(name="apitoken_sid", columnList="sid"), @Index(name="apitoken_expires", columnList="expires DESC"), @Index(name="apitoken_sid_label", columnList="sid, label", unique=true)})
public class ApiToken
extends AuditedVersionedModel
implements Copyable<ApiToken> {
    @Column(length=128, unique=true, nullable=false, updatable=false)
    @JsonView(value={JsonViews.Internal.class})
    @NotCopyable
    private String token;
    @Column(length=64)
    private String label;
    @Column(nullable=true, updatable=true)
    private Instant expires;
    @ManyToOne(fetch=FetchType.EAGER, cascade={})
    @JoinColumn(name="sid", updatable=false, nullable=false)
    @NotCopyable
    private AclSid sid;

    public boolean canEqual(Object other) {
        return other instanceof ApiToken;
    }

    public boolean isCredentialsNonExpired() {
        return this.expires == null || Instant.now().isBefore(this.expires);
    }

    public String getToken() {
        return this.token;
    }

    public String getLabel() {
        return this.label;
    }

    public Instant getExpires() {
        return this.expires;
    }

    public AclSid getSid() {
        return this.sid;
    }

    @JsonView(value={JsonViews.Internal.class})
    public void setToken(String token) {
        this.token = token;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setExpires(Instant expires) {
        this.expires = expires;
    }

    public void setSid(AclSid sid) {
        this.sid = sid;
    }
}

