/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.serialization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.security.acls.domain.BasePermission;

public class Permissions {
    public boolean create;
    public boolean read;
    public boolean write;
    public boolean delete;
    public boolean manage;
    public boolean isPublic = false;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.create ? "c" : "-");
        sb.append(this.isPublic ? "R" : (this.read ? "r" : "-"));
        sb.append(this.write ? "w" : "-");
        sb.append(this.delete ? "d" : "-");
        sb.append(this.manage ? "A" : "-");
        return sb.toString();
    }

    public boolean isGranting(int mask) {
        if (BasePermission.CREATE.getMask() == mask) {
            return this.create;
        }
        if (BasePermission.READ.getMask() == mask) {
            return this.read;
        }
        if (BasePermission.WRITE.getMask() == mask) {
            return this.write;
        }
        if (BasePermission.DELETE.getMask() == mask) {
            return this.delete;
        }
        if (BasePermission.ADMINISTRATION.getMask() == mask) {
            return this.manage;
        }
        throw new UnsupportedOperationException("No such permission with mask=" + mask);
    }

    public Permissions grantAll() {
        this.create = true;
        this.read = true;
        this.write = true;
        this.delete = true;
        this.manage = true;
        return this;
    }

    public Permissions grantNone() {
        this.create = false;
        this.read = false;
        this.write = false;
        this.delete = false;
        this.manage = false;
        return this;
    }

    @JsonIgnore
    public boolean isOneGranting() {
        return this.create || this.read || this.write || this.delete || this.manage;
    }
}

