/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.oauth.component;

import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.genesys.blocks.oauth.model.QAuthorization;
import org.genesys.blocks.oauth.persistence.AuthorizationRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

public class ExpiredAuthorizationEntityCleaner {
    private static final Logger log = LoggerFactory.getLogger(ExpiredAuthorizationEntityCleaner.class);
    private final AuthorizationRepository authorizationRepository;
    private final int expiredEntitiesDelay;

    public ExpiredAuthorizationEntityCleaner(AuthorizationRepository authorizationRepository, int expiredEntitiesDelay) {
        this.authorizationRepository = authorizationRepository;
        this.expiredEntitiesDelay = expiredEntitiesDelay;
    }

    @Scheduled(initialDelay=30000L, fixedDelay=3600000L)
    @Transactional
    public void processExpired() {
        Instant expiredInstant = Instant.now().minus(Math.max(this.expiredEntitiesDelay, 0), ChronoUnit.DAYS);
        log.trace("Searching for the authorization entities expired before: {}", (Object)expiredInstant);
        QAuthorization authorization = QAuthorization.authorization;
        Iterable entitiesForDelete = this.authorizationRepository.findAll(ExpressionUtils.anyOf((Predicate[])new Predicate[]{authorization.authorizationCodeExpiresAt.before((Comparable)expiredInstant).and((Predicate)authorization.accessTokenExpiresAt.isNull()).and((Predicate)authorization.refreshTokenExpiresAt.isNull()), authorization.accessTokenExpiresAt.before((Comparable)expiredInstant).and((Predicate)authorization.refreshTokenExpiresAt.isNull()), authorization.refreshTokenExpiresAt.before((Comparable)expiredInstant)}));
        this.authorizationRepository.deleteAll(entitiesForDelete);
    }
}

