/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.model.filters;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.genesys.blocks.model.AuditedVersionedModel;
import org.genesys.blocks.model.QAuditedVersionedModel;
import org.genesys.blocks.model.filters.TemporalFilter;
import org.genesys.blocks.model.filters.VersionedModelFilter;

public abstract class AuditedVersionedModelFilter<T extends AuditedVersionedModelFilter<T, R>, R extends AuditedVersionedModel>
extends VersionedModelFilter<T, R> {
    private static final long serialVersionUID = 4488044011334369267L;
    public Set<Long> createdBy;
    public Set<Long> lastModifiedBy;
    public TemporalFilter<Instant> createdDate;
    public TemporalFilter<Instant> lastModifiedDate;

    protected List<Predicate> collectPredicates(EntityPathBase<R> instance, QAuditedVersionedModel auditedVersionedModel) {
        List predicates = super.collectPredicates(instance, auditedVersionedModel._super);
        if (CollectionUtils.isNotEmpty(this.createdBy)) {
            predicates.add(auditedVersionedModel.createdBy.in(this.createdBy));
        }
        if (CollectionUtils.isNotEmpty(this.lastModifiedBy)) {
            predicates.add(auditedVersionedModel.lastModifiedBy.in(this.lastModifiedBy));
        }
        if (this.createdDate != null) {
            predicates.add(this.createdDate.buildQuery(auditedVersionedModel.createdDate));
        }
        if (this.lastModifiedDate != null) {
            predicates.add(this.lastModifiedDate.buildQuery(auditedVersionedModel.lastModifiedDate));
        }
        return predicates;
    }

    public Set<Long> createdBy() {
        return this.createdBy;
    }

    public Set<Long> lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public TemporalFilter<Instant> createdDate() {
        return this.createdDate;
    }

    public TemporalFilter<Instant> lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public AuditedVersionedModelFilter<T, R> createdBy(Set<Long> createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public AuditedVersionedModelFilter<T, R> lastModifiedBy(Set<Long> lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    public AuditedVersionedModelFilter<T, R> createdDate(TemporalFilter<Instant> createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    public AuditedVersionedModelFilter<T, R> lastModifiedDate(TemporalFilter<Instant> lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditedVersionedModelFilter)) {
            return false;
        }
        AuditedVersionedModelFilter other = (AuditedVersionedModelFilter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<Long> this$createdBy = this.createdBy();
        Set<Long> other$createdBy = other.createdBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        Set<Long> this$lastModifiedBy = this.lastModifiedBy();
        Set<Long> other$lastModifiedBy = other.lastModifiedBy();
        if (this$lastModifiedBy == null ? other$lastModifiedBy != null : !((Object)this$lastModifiedBy).equals(other$lastModifiedBy)) {
            return false;
        }
        TemporalFilter<Instant> this$createdDate = this.createdDate();
        TemporalFilter<Instant> other$createdDate = other.createdDate();
        if (this$createdDate == null ? other$createdDate != null : !this$createdDate.equals(other$createdDate)) {
            return false;
        }
        TemporalFilter<Instant> this$lastModifiedDate = this.lastModifiedDate();
        TemporalFilter<Instant> other$lastModifiedDate = other.lastModifiedDate();
        return !(this$lastModifiedDate == null ? other$lastModifiedDate != null : !this$lastModifiedDate.equals(other$lastModifiedDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuditedVersionedModelFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set<Long> $createdBy = this.createdBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        Set<Long> $lastModifiedBy = this.lastModifiedBy();
        result = result * 59 + ($lastModifiedBy == null ? 43 : ((Object)$lastModifiedBy).hashCode());
        TemporalFilter<Instant> $createdDate = this.createdDate();
        result = result * 59 + ($createdDate == null ? 43 : $createdDate.hashCode());
        TemporalFilter<Instant> $lastModifiedDate = this.lastModifiedDate();
        result = result * 59 + ($lastModifiedDate == null ? 43 : $lastModifiedDate.hashCode());
        return result;
    }
}

