/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.security.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.genesys.blocks.model.BasicModel;

import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * ACL Entry represents permissions of {@link AclSid} on a particular entity
 * (through {@link AclObjectIdentity}).
 */
@Entity
@Table(name = "acl_entry", uniqueConstraints = { @UniqueConstraint(columnNames = { "acl_object_identity", "ace_order" }), 
		@UniqueConstraint(columnNames = { "acl_object_identity", "sid", "mask" }) })
@Getter
@Setter
@ToString(callSuper = true)
public class AclEntry extends BasicModel {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -1047000445685485825L;

	/** The acl object identity. */
	@ManyToOne(fetch = FetchType.LAZY, cascade = {}, optional = false)
	@JoinColumn(name = "acl_object_identity", nullable = false)
	@JsonIgnore
	@ToString.Exclude
	private AclObjectIdentity aclObjectIdentity;

	/** The acl sid. */
	@ManyToOne(fetch = FetchType.LAZY, cascade = {}, optional = false)
	@JoinColumn(name = "sid", nullable = false)
	@JsonIdentityReference(alwaysAsId = false)
	private AclSid aclSid;

	/** The ace order. */
	@Column(name = "ace_order", nullable = false, length = 11)
	private long aceOrder;

	/** The mask. */
	@Column(name = "mask", nullable = false)
	private int mask;

	/** The granting. */
	@Column(name = "granting", nullable = false, length = 1)
	private boolean granting;

	/** The audit success. */
	@Column(name = "audit_success", nullable = false, length = 1)
	private boolean auditSuccess;

	/** The audit failure. */
	@Column(name = "audit_failure", nullable = false, length = 1)
	private boolean auditFailure;

	@Override
	public boolean canEqual(Object other) {
		return other instanceof AclEntry;
	}
}
